package com.ekingwin.bas.cloud.demo.resources;

import io.github.swagger2markup.GroupBy;
import io.github.swagger2markup.Language;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.builder.Swagger2MarkupConfigBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import org.junit.Test;

import java.net.URL;
import java.nio.file.Paths;

//@RunWith(SpringRunner.class)
//@SpringBootTest(classes = Demo2ServiceApplication.class)
public class TestApiExportService{

    // swagger-ui.html页面中能找到此链接
//    private final static  String SWAGGER_URI = "http://middleware.jiucaiyun.cn/mid-platform/v2/api-docs";
    private final static  String SWAGGER_URI = "http://localhost:8000/test/v2/api-docs";
    private final static  String TARGET_PATH = "./docs/asciidoc/generated";

	/**
     * 生成AsciiDocs格式文档
     * @throws Exception
     */
    @Test
    public void generateAsciiDocs() throws Exception {
        //    输出Ascii格式
        Swagger2MarkupConfig config = new Swagger2MarkupConfigBuilder()
                .withMarkupLanguage(MarkupLanguage.ASCIIDOC)
                .withOutputLanguage(Language.ZH)
                .withPathsGroupedBy(GroupBy.TAGS)
                .withGeneratedExamples()
                .withoutInlineSchema()
                .build();
        Swagger2MarkupConverter converter = Swagger2MarkupConverter
                                                .from(new URL(SWAGGER_URI))
                                                .withConfig(config)
                                                .build();
        converter.toFolder(Paths.get(TARGET_PATH));
        converter.toFile(Paths.get(TARGET_PATH, "all"));
    }

//    /**
//     * 生成Markdown格式文档
//     * @throws Exception
//     */
//    @Test
//    public void generateMarkdownDocs() throws Exception {
//        //    输出Markdown格式
//        Swagger2MarkupConfig config = new Swagger2MarkupConfigBuilder()
//                .withMarkupLanguage(MarkupLanguage.MARKDOWN)
//                .withOutputLanguage(Language.ZH)
//                .withPathsGroupedBy(GroupBy.TAGS)
//                .withoutPathSecuritySection()
//                .withGeneratedExamples()
//                .withoutInlineSchema().withAnchorPrefix("a")
////                .withListDelimiter()
////                .withSeparatedDefinitions()
////                .withSeparatedOperations()
//                .build();
//
//        Swagger2MarkupConverter.from(new URL("http://localhost:8000/test/v2/api-docs"))
//                .withConfig(config)
//                .build()
//                .toFolder(Paths.get("./docs/mddoc/generated"));
//    }
//
//    /**
//     * 生成Markdown格式文档,并汇总成一个文件
//     * @throws Exception
//     */
//    @Test
//    public void generateMarkdownDocsToFile() throws Exception {
//        //    输出Markdown到单文件
//        Swagger2MarkupConfig config = new Swagger2MarkupConfigBuilder()
//                .withMarkupLanguage(MarkupLanguage.MARKDOWN)
//                .withOutputLanguage(Language.ZH)
//                .withPathsGroupedBy(GroupBy.TAGS)
//                .withoutPathSecuritySection()
//                .withGeneratedExamples()
//                .withoutInlineSchema()
//                .build();
//
//        Swagger2MarkupConverter.from(new URL("http://localhost:8000/test/v2/api-docs"))
//                .withConfig(config)
//                .build()
//                .toFile(Paths.get("./docs/mddoc/generated/all"));
//    }
}
