package com.ekingwin.bas.cloud.exam.dto.entity;


import com.ekingwin.bas.cloud.infra.dao.entity.BaseEntity;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 问题
 */
@Table(name = "BAS_EXAM_QUESTION_TEST")
public class Question extends BaseEntity {

    private static final long serialVersionUID = -7469321517627819733L;
    @Id
    private String id;
    // 所属试卷
    private String testId;
    // 考试人id
    @Transient
    private String stuffId;
    // 问题题目
    private String questionTitle;
    // 问题内容
    private String questionContent;
    // 问题答案 或者 我的答案
    private String answer;
    // 该题分数
    @Column(name = "SINGLESCORE")
    private long singleScore;
    // 创建时间
    private Date createTime;
    // 创建人
    private String createBy;
    // 是否删除
    @Column(name = "ISDELETE")
    private long isDelete;
    // 所属科目
    private String subjectId;
    // 类型  1单选题 2多选题 3问答题
    private long type;
    // 答题批次
    @Transient
    private String answerBatch;
    // 是否正确
    @Transient
    private long correct;
    // 所属科目名字
    @Transient
    private String belongSubject;

    public Question(String id, String testId, String stuffId, String questionTitle, String questionContent, String answer, long singleScore, Date createTime, String createBy, long isDelete, String subjectId, long type, String answerBatch, long correct, String belongSubject) {
        this.id = id;
        this.testId = testId;
        this.stuffId = stuffId;
        this.questionTitle = questionTitle;
        this.questionContent = questionContent;
        this.answer = answer;
        this.singleScore = singleScore;
        this.createTime = createTime;
        this.createBy = createBy;
        this.isDelete = isDelete;
        this.subjectId = subjectId;
        this.type = type;
        this.answerBatch = answerBatch;
        this.correct = correct;
        this.belongSubject = belongSubject;
    }

    public String getBelongSubject() {
        return belongSubject;
    }

    public void setBelongSubject(String belongSubject) {
        this.belongSubject = belongSubject;
    }

    public String getAnswerBatch() {
        return answerBatch;
    }

    public void setAnswerBatch(String answerBatch) {
        this.answerBatch = answerBatch;
    }


    public long getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(long isDelete) {
        this.isDelete = isDelete;
    }

    public long getCorrect() {
        return correct;
    }

    public void setCorrect(long correct) {
        this.correct = correct;
    }

    public Question() {
    }

    public String getStuffId() {
        return stuffId;
    }

    public void setStuffId(String stuffId) {
        this.stuffId = stuffId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTestId() {
        return testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getQuestionTitle() {
        return questionTitle;
    }

    public void setQuestionTitle(String questionTitle) {
        this.questionTitle = questionTitle;
    }

    public String getQuestionContent() {
        return questionContent;
    }

    public void setQuestionContent(String questionContent) {
        this.questionContent = questionContent;
    }

    public String getAnswer() {
        return answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public long getSingleScore() {
        return singleScore;
    }

    public void setSingleScore(long singleScore) {
        this.singleScore = singleScore;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public long getDelete() {
        return isDelete;
    }

    public void setDelete(long delete) {
        this.isDelete = delete;
    }

    public String getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public long getType() {
        return type;
    }

    public void setType(long type) {
        this.type = type;
    }
}
