package com.ekingwin.bas.cloud.exam.dto.entity;


import com.ekingwin.bas.cloud.infra.dao.entity.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 试卷
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "BAS_EXAM_TEST")
public class TestPapers extends BaseEntity {

    private static final long serialVersionUID = -4396960034746549794L;

    @Transient
    private String id;
    //编号及名称
    private String codeName;
    // 试卷id
    @Id
    @Column(name = "TEST_ID")
    private String testId;
    //bpm流程id
    private String bpmId;
    // 所属科目
    private String subjectId;
    // 试卷名字
    private String testName;
    // 该试卷总分
    @Column(name ="total_score")
    private long totalScore;
    // 创建时间
    private Date createTime;
    // 更新时间
    @Transient
    private Date updateTime;
    // 是否删除 0不删除 1删除
    private Boolean isDelete;
    // 创建人empuid
    private String createBy;
    // 中文名称
    @Transient
    private String cnname;
    // 是否已做
    @Transient
    private Boolean done;
    // 是否自定义
    @Transient
    private Boolean DIY;
    // 所属科目名字
    @Transient
    private String belongSubject;
    //合格分数
    private Integer passScore;
    // 答题人所属部门
    @Transient
    private String department;
    // 试题
    @Transient
    private List<Question> questions;

    public Boolean getDelete() {
        return isDelete;
    }

    public void setDelete(Boolean delete) {
        isDelete = delete;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCodeName() {
        return codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getTestId() {
        return testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public String getTestName() {
        return testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public long getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(long totalScore) {
        this.totalScore = totalScore;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Boolean getDone() {
        return done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    public Boolean getDIY() {
        return DIY;
    }

    public void setDIY(Boolean dIY) {
        DIY = dIY;
    }

    public String getBelongSubject() {
        return belongSubject;
    }

    public void setBelongSubject(String belongSubject) {
        this.belongSubject = belongSubject;
    }

    public Integer getPassScore() {
        return passScore;
    }

    public void setPassScore(Integer passScore) {
        this.passScore = passScore;
    }

    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public List<Question> getQuestions() {
        return questions;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public String getBpmId() {
        return bpmId;
    }

    public void setBpmId(String bpmId) {
        this.bpmId = bpmId;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TestPapers that = (TestPapers) o;
        return Objects.equals(testName, that.testName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), testName);
    }
}
