package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dto.QuerySubjectVO;
import com.ekingwin.bas.cloud.exam.dto.SubjectVerifyVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Subject;
import com.github.pagehelper.PageInfo;


public interface SubjectService {
    /**
     * 添加科目
     *
     * @param subject
     * @return
     */
    int addSubject(Subject subject);


    /**
     * 根据id删除科目
     *
     * @param id
     * @return
     */
    int delSubjectById(String id);

    /**
     * 查询科目
     *
     * @return
     */
    PageInfo<Subject> querySubject(QuerySubjectVO querySubjectVO);

    /**
     * 修改科目信息
     *
     * @param subject
     * @return
     */
    int changeSubjectInfo(Subject subject);

    /**
     * 验证是否存在
     * @param subject
     * @return
     */
    SubjectVerifyVO verify(Subject subject);
}
