package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dto.QueryTestVO;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.IBaseEntityService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;

import java.util.List;

public interface TestPaperService extends IBaseEntityService<TestPapers> {
    /**
     * 创建试卷
     *
     * @param test
     * @return
     */
    int createTest(TestPapers test);

    /**
     * 查询我的所有试卷
     *
     * @return
     */
    List<TestPapers> queryMyAllTest();

    /**
     * 查询试卷详情
     *
     * @param queryTestVO
     * @return
     */
    TestPapers queryTestDetails(QueryTestVO queryTestVO);

    int deleteTestPapers(String ids);

    PageCriteria<TestPapers> queryTestPapers(QueryDTO query) throws BasException;

    TestPapers getTestPapersDetailsInfo(String id);

    /**
     * 修改
     *
     * @param test
     * @return
     */
    int editTest(TestPapers test);
}
