package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dao.SubjectDao;
import com.ekingwin.bas.cloud.exam.dto.QuerySubjectVO;
import com.ekingwin.bas.cloud.exam.dto.SubjectVerifyVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Subject;
import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.UUID;

@Primary
@Service
public class SubjectServiceImpl implements SubjectService {

    @Override
    public int addSubject(Subject subject) {
        Date date = new Date();
        String id = UUID.randomUUID().toString().replace("-", "");
        subject.setId(id.trim());
        String user = UserUtils.getCurrentUser();
        subject.setCreateBy(user);
        subject.setCreateTime(date);
        subject.setUpdateTime(date);
        subject.setDelete(false);
        return subjectDao.save(subject);
    }

    @Override
    @Transactional
    public int delSubjectById(String ids) {
        int count = 0;
        String[] id = ids.split(",");
        for (String s : id) {

            count = subjectDao.delete(s);
        }
        return count;
    }

    @Override
    public PageInfo<Subject> querySubject(QuerySubjectVO querySubjectVO) {
        PageHelper.startPage(querySubjectVO.getStartPage(), querySubjectVO.getPageSize());
        List<Subject> subjects = subjectDao.query(querySubjectVO);
        PageInfo<Subject> subjectPageInfo = new PageInfo(subjects);
        return subjectPageInfo;

    }

    @Override
    public int changeSubjectInfo(Subject subject) {
        subject.setUpdateTime(new Date());
        int res = subjectDao.updateSubjectInfo(subject);
        return res;
    }

    @Override
    public SubjectVerifyVO verify(Subject subject) {
        SubjectVerifyVO subjectVerifyVO = new SubjectVerifyVO();
        subjectVerifyVO.setSuccess(true);

        if(StringUtils.isNotBlank(subject.getSubjectName())) {
            QuerySubjectVO querySubjectVO = new QuerySubjectVO();
            querySubjectVO.setSubjectId(subject.getId());
            querySubjectVO.setSubjectName(subject.getSubjectName());
            int namecount = subjectDao.verify(querySubjectVO);
            if(namecount>0){
                subjectVerifyVO.setSuccess(false);
                subjectVerifyVO.setMsg("考试类型名称已存在");
            }
        }

        if(StringUtils.isNotBlank(subject.getSubjectNo())) {
            QuerySubjectVO querySubjectVO = new QuerySubjectVO();
            querySubjectVO.setSubjectId(subject.getId());
            querySubjectVO.setSubjectNo(subject.getSubjectNo());
            int count = subjectDao.verify(querySubjectVO);
            if(count>0){
                subjectVerifyVO.setSuccess(false);
                subjectVerifyVO.setMsg("考试类型编号已存在");
                return subjectVerifyVO;
            }
        }
        return subjectVerifyVO;
    }

    @Autowired
    SubjectDao subjectDao;
}
