package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dao.QuestionDao;
import com.ekingwin.bas.cloud.exam.dao.ScoreDao;
import com.ekingwin.bas.cloud.exam.dao.TestPaperDao;
import com.ekingwin.bas.cloud.exam.dto.QueryTestVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.cloud.exam.dto.entity.Score;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import javax.annotation.Resource;
import java.util.*;

@Primary
@Service
public class TestPaperServiceImpl extends BaseService implements TestPaperService {

    /**
     * 创建试卷
     *
     * @param test
     * @return
     */
    @Override
    @Transactional
    public int createTest(TestPapers test) {
        String testId = UUID.randomUUID().toString().replace("-", "");
        test.setTestId(testId.trim());
        test.setIsDelete(false);
        Date date = new Date();
        test.setCreateTime(date);
        String currentUser = UserUtils.getCurrentUser();
        test.setCreateBy(currentUser);

        int totalScore = 0;
        List<Question> questions = test.getQuestions();
        for (Question question : questions) {
            question.setTestId(test.getTestId());
            question.setSubjectId(test.getSubjectId());
            question.setCreateBy(currentUser);
            questionsService.addQuestion(question, test.getDIY());
            totalScore += question.getSingleScore();
        }
        test.setTotalScore(totalScore);
        return testPaperDao.insertTest(test);
    }

    @Override
    public int editTest(TestPapers test) {
        // 先删后增
        questionDao.deleteQuestionTest(test.getTestId());
        questionDao.deleteBySubjectId(test.getSubjectId());

        String currentUser = UserUtils.getCurrentUser();
        test.setCreateBy(currentUser);

        int totalScore = 0;
        List<Question> questions = test.getQuestions();
        for (Question question : questions) {
            question.setTestId(test.getTestId());
            question.setSubjectId(test.getSubjectId());
            question.setCreateBy(currentUser);
            questionsService.editQuestion(question);
            totalScore += question.getSingleScore();
        }

        test.setTotalScore(totalScore);
        return testPaperDao.updateByPrimaryKeySelective(test);
    }

    /**
     * 查找所有试卷
     *
     * @return
     */
    @Override
    @Transactional
    public List<TestPapers> queryMyAllTest() {
        ArrayList<TestPapers> tests = new ArrayList<>();
        String userId = UserUtils.getCurrentUser();

        // 查询未作试题
        List<TestPapers> undoTests = testPaperDao.queryUndoTestByUserId(userId);
        for (TestPapers undoTest : undoTests) {
            undoTest.setDone(false);
//            List<Question> questions = questionDao.queryQuestionByTestId(undoTest.getTestId());
//            undoTest.setQuestions(questions);
        }

        // 查询已做试题
        List<TestPapers> doneTests = new ArrayList<>();

        List<Score> scoreInfos = scoreDao.queryDoneTestByUserId(userId);
        for (Score scoreInfo : scoreInfos) {
            TestPapers test = testPaperDao.queryTestByTestId(scoreInfo.getTestId());
            if (test != null) {
                test.setDone(true);
//                List<Question> questions = questionDao.queryMyAnswerByTestIdAndAnswerBatch(scoreInfo.getTestId(), scoreInfo.getAnswerBatch(), userId);
//                test.setQuestions(questions);
                doneTests.add(test);
            }
        }
        tests.addAll(undoTests);
        tests.addAll(doneTests);
        // 去重
        Set<TestPapers> resultSet = new HashSet<>(tests);
        tests = new ArrayList<>(resultSet);
        return tests;
    }

    /**
     * 查找具体试卷详细内容
     *
     * @param queryTestVO
     * @return
     */
    @Override
    @Transactional
    public TestPapers queryTestDetails(QueryTestVO queryTestVO) {
        String userID = UserUtils.getCurrentUser();
        List<Question> questions = null;
        TestPapers testPapers = null;
        // 是否已做
        if (queryTestVO.getDone()) {
            // 从已做试题库查询
            testPapers = testPaperDao.queryTestByTestIdAndBatchAndUserId(userID, queryTestVO.getTestId(), queryTestVO.getAnswerBatch());
            testPapers.setDone(true);
            questions = questionDao.queryAnswerByTestIdAndBatchAndUserId(userID, queryTestVO.getTestId(), queryTestVO.getAnswerBatch());
        } else {
            // 从未做试题库查询
            testPapers = testPaperDao.queryTestByTestId(queryTestVO.getTestId());
            testPapers.setDone(false);
            questions = questionDao.queryQuestionByTestId(queryTestVO.getTestId());
        }

        testPapers.setQuestions(questions);

        return testPapers;
    }

    /**
     * 删除试卷
     *
     * @param ids
     * @return
     */
    @Transactional
    @Override
    public int deleteTestPapers(String ids) {
        String[] testIds = ids.split(",");
        int count = 0;
        for (String testId : testIds) {
            count += testPaperDao.deleteTestPapers(testId);
            count += questionDao.deleteQuestionTest(testId);
        }
        return count;
    }

    /**
     * 条件查找试卷
     *
     * @param query
     * @return
     */
    @Override
    public PageCriteria<TestPapers> queryTestPapers(QueryDTO query) throws BasException {
        try {
            Example example = buildQuery(query, TestPapers.class);
            return query(query, () -> testPaperDao.selectTestPapers(example), TestPapers.class);
        } catch (Exception e) {
            throw new BasException(e.getMessage());
        }
    }

    /**
     * 查找试卷具体内容
     *
     * @param id
     * @return
     */
    @Override
    public TestPapers getTestPapersDetailsInfo(String id) {
        TestPapers testPapers = testPaperDao.queryTestByTestId(id);
        if (null == testPapers) {
            return null;
        }
        List<Question> questions = questionDao.queryQuestionByTestId(id);
        testPapers.setQuestions(questions);
        return testPapers;
    }

    @Override
    public boolean save(TestPapers object) throws BasException {
        return false;
    }

    @Override
    public boolean delete(String id) throws BasException {
        return false;
    }

    @Override
    public PageCriteria<TestPapers> query(QueryDTO query) throws BasException {
        return null;
    }

    @Override
    public TestPapers get(String id) throws BasException {
        return null;
    }

    @Resource
    TestPaperDao testPaperDao;
    @Resource
    QuestionDao questionDao;
    @Resource
    ScoreDao scoreDao;
    @Resource
    private QuestionsService questionsService;
}
