package com.ekingwin.bas.cloud.exam.web;

import com.ekingwin.bas.cloud.exam.dto.BackResult;
import com.ekingwin.bas.cloud.exam.dto.QuestionVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.cloud.exam.service.QuestionsService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "试题接口")
@Controller
@RestController
@RequestMapping("/exam/question")
public class QuestionController {

    /**
     * 添加试题
     */
    @ApiOperation("添加试题")
    @PostMapping("/addQuestions")
    public BackResult addQuestions(@RequestBody QuestionVO questionVO) {
        if (questionVO == null) {
            return new BackResult(400, "传入数据为空", null);
        }
        List<Question> questions = questionVO.getQuestions();
        int res = questionsService.addQuestions(questions);
        if (res > 0) {
            return new BackResult(200, "添加成功", null);
        }
        return new BackResult(200, "添加失败", null);
    }

    /**
     * 根据科目选择试题
     */
    @ApiOperation("根据科目获取试题")
    @GetMapping("/queryQuestions/{subjectId}/{startPage}/{pageSize}")
    public BackResult queryQuestionsBySubjectId(@PathVariable("subjectId") String subjectId,
                                                @PathVariable("startPage") Integer startPage,
                                                @PathVariable("pageSize") Integer pageSize) {

        PageInfo<Question> questions = questionsService.queryQuestionsBySubjectId(subjectId, startPage, pageSize);
        return new BackResult(200, "获取成功", questions);
    }

    /**
     * 修改试题
     */
    @ApiOperation("修改试题")
    @PostMapping("/editQuestions")
    public BackResult editQuestions(@RequestBody QuestionVO questionVO) {
        if (questionVO == null) {
            return new BackResult(400, "传入数据为空", null);
        }
        List<Question> questions = questionVO.getQuestions();
        int res = questionsService.editQuestions(questions);
        if (res > 0) {
            return new BackResult(200, "修改成功", null);
        }
        return new BackResult(200, "修改失败", null);
    }

    @Autowired
    QuestionsService questionsService;

}
