package com.ekingwin.bas.cloud.exam.web;

import com.ekingwin.bas.cloud.exam.dto.BackResult;
import com.ekingwin.bas.cloud.exam.dto.QuerySubjectVO;
import com.ekingwin.bas.cloud.exam.dto.SubjectVerifyVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Subject;
import com.ekingwin.bas.cloud.exam.service.SubjectService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;


@Api(tags = "科目接口", description = "科目增删改查")
@Controller
@RequestMapping("/exam/subject")
@RestController
public class SubjectController {

    /**
     * 添加科目
     */
    @ApiOperation("添加科目")
    @PostMapping("/addSubject")
    public BackResult addSubject(@RequestBody Subject subject, @RequestParam(required = false) String username) {
        if (subject == null) {
            return new BackResult(400, "添加数据为空", false);
        }
        //验证
        SubjectVerifyVO subjectVerifyVO = subjectService.verify(subject);
        if (!subjectVerifyVO.isSuccess()) {
            return new BackResult(400, subjectVerifyVO.getMsg(), false);
        }

        int res = subjectService.addSubject(subject);
        if (res > 0) {
            return new BackResult(200, "添加成功", true);
        }
        return new BackResult(400, "添加失败", false);
    }

    /**
     * 删除科目
     */
    @ApiOperation("根据科目id批量删除")
    @GetMapping("/delSubjectById")
    public BackResult dleSubjectById(@RequestParam String ids) {
        if (StringUtils.isBlank(ids)) {
            return new BackResult(200, "删除失败", null);
        }
        int res = subjectService.delSubjectById(ids);
        if (res > 0) {
            return new BackResult(200, "删除成功", null);
        }
        return new BackResult(400, "删除失败", null);
    }

    /**
     * 查找科目
     */
    @ApiOperation("分页查找科目")
    @PostMapping("/querySubject")
    public BackResult querySubjectById(@RequestBody QuerySubjectVO querySubjectVO) {
        if (querySubjectVO.getStartPage() == null) {
            querySubjectVO.setStartPage(0);
        }
        if (querySubjectVO.getPageSize() == null || querySubjectVO.getPageSize() == 0) {
            querySubjectVO.setPageSize(10);
        }
        PageInfo<Subject> subjects = subjectService.querySubject(querySubjectVO);

        return new BackResult(200, "查询成功", subjects);
    }

    /**
     * 修改科目信息
     *
     * @param subject
     * @return
     */
    @ApiOperation("修改科目信息")
    @PostMapping("/changeSubjectInfo")
    public BackResult changeSubjectInfo(@RequestBody Subject subject) {
        if (subject == null) {
            return new BackResult(400, false);
        }
        //验证
        SubjectVerifyVO subjectVerifyVO = subjectService.verify(subject);
        if (!subjectVerifyVO.isSuccess()) {
            return new BackResult(400, subjectVerifyVO.getMsg(), false);
        }
        int res = subjectService.changeSubjectInfo(subject);
        if (res > 0) {
            return new BackResult(200, true);
        }
        return new BackResult(400, false);
    }

    @Autowired
    private SubjectService subjectService;
}
