package com.ekingwin.bas.cloud.exam.service;

import com.ekingwin.bas.cloud.exam.dao.QuestionDao;
import com.ekingwin.bas.cloud.exam.dao.ScoreDao;
import com.ekingwin.bas.cloud.exam.dao.SubjectDao;
import com.ekingwin.bas.cloud.exam.dao.TestPaperDao;
import com.ekingwin.bas.cloud.exam.dto.QueryTestVO;
import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.cloud.exam.dto.entity.Score;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.org.manager.IOrganizationManager;
import com.ekingwin.bas.cloud.test.BaseCommonTestService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.spring.annotation.MapperScan;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;

/**
 * @author chenjb
 * @version 1.0.0
 * @ClassName TestPaperServiceImplTest.java
 * @Description TODO
 * @createTime 2021/6/10 13:59
 */
@Order()
class TestPaperServiceImplTest extends BaseCommonTestService {

    @Test
    void createTest() {
        /*
        要明确单元测试中，测试一个指定方法的目标：
	    一般情况下，你要测试的仅仅是指定方法自身的逻辑，而一个方法应当只实现一个功能；因此我们只需要定义虚拟的输入参数（如果参数是对象，则只需要定义对象中那些在方法逻辑中需要使用到的属性即可），并在调用方法后，获取到方法的返回值，判断该返回值是否符合预期即可；当该方法中调用调用了其他类的方法时，由于我们此时只关注当前方法的逻辑而
         */
        //生成一些虚拟的测试数据；这里不需要设置所有的属性值，只需要定义一些测试目标方法中的逻辑需要用到的即可
        TestPapers testPapers = new TestPapers();
        testPapers.setTotalScore(100);
        testPapers.setDIY(true);
        testPapers.setPassScore(60);
        //比如以下参数在方法逻辑中并没有使用来控制逻辑，所以并不用设置（除非你要用来测试数据库层的写入逻辑）
        testPapers.setSubjectId("123");
        testPapers.setTestName("测试name");
        testPapers.setCodeName("测试code");
        testPapers.setBpmId("123");

        List<Question> questions = new ArrayList<>();
        Question question = new Question();
        question.setQuestionContent("A|B|C|D");
        question.setSingleScore(50);
        question.setType(1);

        //比如以下参数在方法逻辑中并没有使用来控制逻辑，所以并不用设置（除非你要用来测试数据库层的写入逻辑）
        question.setQuestionTitle("quest1");
        question.setAnswer("A");
        question.setBelongSubject("123");
        question.setSubjectId("123");

        questions.add(question);

        new Question();
        question.setQuestionContent("A|B|C|D");
        question.setSingleScore(50);
        question.setType(3);

        //比如以下参数在方法逻辑中并没有使用来控制逻辑，所以并不用设置（除非你要用来测试数据库层的写入逻辑）
        question.setQuestionTitle("quest2");
        question.setAnswer("A|B");
        question.setBelongSubject("123");
        question.setSubjectId("123");

        questions.add(question);

        testPapers.setQuestions(questions);

        //如果我们只测试业务方法的逻辑，不会测试数据库层，所以涉及到的数据库相关操作直接通过打桩模拟返回
        //如果过要同时测试数据层的方法，去掉下面的打桩代码，并去掉初始化类中的mockbean声明
        Mockito.doReturn(1).when(testPaperDao).insertTest(any());

        //由此方法的逻辑可知，该方法中调用了questionsService.addQuestion，这里并未对该方法进行mock，因此这里其实是同时测试了两个方法
        //调用测试的目标方法
        int i = testPaperService.createTest(testPapers);
        Assertions.assertTrue(i > 0);

        //getTestPapersDetailsInfo方法中会用到的数据库方法，直接打桩返回
        Mockito.doReturn(testPapers).when(testPaperDao).queryTestByTestId(anyString());
        Mockito.doReturn(questions).when(questionDao).queryQuestionByTestId(anyString());

        //调用测试的目标方法
        testPapers = testPaperService.getTestPapersDetailsInfo(testPapers.getTestId());

        //断言，判断结果是否符合预期
        Assertions.assertNotNull(testPapers);
        Assertions.assertEquals(testPapers.getTotalScore(), 100);
        Assertions.assertNotNull(testPapers.getQuestions());
        Assertions.assertEquals(testPapers.getQuestions().size(), 2);

    }

    @Test
    void queryMyAllTest() {
        List<TestPapers> undoList = new ArrayList<>();
        TestPapers test = new TestPapers();
        test.setTestId("1");
        undoList.add(test);
        test = new TestPapers();
        test.setTestId("2");
        undoList.add(test);
        test = new TestPapers();
        test.setTestId("3");
        undoList.add(test);
        test = new TestPapers();
        test.setTestId("4");
        undoList.add(test);
        test = new TestPapers();
        test.setTestId("5");
        undoList.add(test);


        List<Score> doneList = new ArrayList<>();
        Score score = new Score();
        score.setTestId("1");
        doneList.add(score);


        Mockito.doReturn(undoList).when(testPaperDao).queryUndoTestByUserId(null);
        Mockito.doReturn(doneList).when(scoreDao).queryDoneTestByUserId(null);

        TestPapers testPaper = new TestPapers();
        testPaper.setTestId("6");
        Mockito.doReturn(testPaper).when(testPaperDao).queryTestByTestId("1");

        List<TestPapers> myList = testPaperService.queryMyAllTest();

        Assertions.assertEquals(6, myList.size());
        Assertions.assertTrue(myList.get(5).getDone());

    }

    @Test
    void queryTestDetails() {
        TestPapers test = new TestPapers();
        test.setTestId("1");

        Mockito.doReturn(test).when(testPaperDao).queryTestByTestIdAndBatchAndUserId(null, null, null);
        Mockito.doReturn(new ArrayList<>()).when(questionDao).queryAnswerByTestIdAndBatchAndUserId(null, null, null);

        test = new TestPapers();
        test.setTestId("2");
        Mockito.doReturn(test).when(testPaperDao).queryTestByTestId(null);
        Mockito.doReturn(new ArrayList<>()).when(questionDao).queryQuestionByTestId(null);

        QueryTestVO queryTestVO = new QueryTestVO();
        queryTestVO.setDone(true);
        test = testPaperService.queryTestDetails(queryTestVO);
        Assertions.assertEquals("1", test.getTestId());


        queryTestVO = new QueryTestVO();
        queryTestVO.setDone(false);
        test = testPaperService.queryTestDetails(queryTestVO);
        Assertions.assertEquals("2", test.getTestId());
    }

    @Test
    void deleteTestPapers() {
        int result = testPaperService.deleteTestPapers("1,2,3");
        Assertions.assertEquals(0, result);
    }

    @Test
    void queryTestPapers() throws BasException {
//        Mockito.doReturn(new ArrayList<>()).when(testPaperDao).selectTestPapers(any(Example.class));

        Config config = new Config();
        EntityHelper.initEntityNameMap(TestPapers.class, config);

        Mockito.when(testPaperDao.selectTestPapers(any(Example.class))).thenReturn(new ArrayList<>());
        PageCriteria<TestPapers> result = testPaperService.queryTestPapers(new QueryDTO());
    }

    @Test
    void getTestPapersDetailsInfo() {
    }

    @Test
    void editTest() {
    }

    @SpringBootApplication(scanBasePackages = {"com.ekingwin.bas.cloud"})
    @MapperScan({"com.ekingwin.bas.cloud.**.dao"})
    static class InnerConfig {

        /*
         * 目前tkmapper扫描加载的dao接口，会覆盖mockBean导致mockBean无法生效（无论如何都会调用原始方法）；
         * 所以如果要使dao的mock生效，需要在这里手工初始化测试过程中涉及到的dao接口；
         * 当然，如果你想要在测试业务方法时，同时测试数据库层的接口，可以不加这些配置，并“去掉”测试方法中的打桩逻辑
         */

        @Bean(name = "testPaperDao")
        public TestPaperDao getTestPaperDao() {
            return testPaperDao;
        }

        @Bean(name = "questionDao")
        public QuestionDao getQuestionDao() {
            return questionDao;
        }

        @Bean(name = "scoreDao")
        public ScoreDao getScoreDao() {
            return scoreDao;
        }

        @MockBean
        private TestPaperDao testPaperDao;
        @MockBean
        private QuestionDao questionDao;
        @MockBean
        private ScoreDao scoreDao;
    }

    @Resource
    private TestPaperService testPaperService;

    /*
        对于在configuration中预先初始化的mockbean对象， 这需要通过@Resource或者@Autowired注入
     */
    @Resource
    private TestPaperDao testPaperDao;
    @Resource
    private QuestionDao questionDao;
    @Resource
    private ScoreDao scoreDao;

    @MockBean
    private SubjectDao subjectDao;
    @MockBean
    private IOrganizationManager organizationManager;
//    @MockBean
//    private TestPaperDao testPaperDao;
}