package com.ekingwin.bas.cloud.exam.dao;


import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.mapper.BasMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface QuestionDao extends BasMapper<Question> {
    int save(@Param("question") Question question);

    List<Question> queryQuestionsBySubjectId(@Param("subjectId") String subjectId);

    Question queryQuestionByTestIdAndID(@Param("testId") String testId, @Param("subjectId") String subjectId, @Param("id") String id);

    int insertMyAnswer(@Param("answerId") String answerId, @Param("question") Question question);

    List<Question> queryQuestionByTestId(@Param("testId") String testId);

    List<Question> queryMyAnswerByTestIdAndAnswerBatch(@Param("testId") String testId,
                                                       @Param("answerBatch") String answerBatch, @Param("userId") String userId);

    List<Question> queryQuestionByTestId(@Param("testId") String testId,
                                         @Param("answerBatch") String answerBatch);

    List<Question> queryAnswerByTestIdAndBatchAndUserId(@Param("userId") String userId,
                                                        @Param("testId") String testId, @Param("answerBatch") String answerBatch);

    int deleteQuestionTest(@Param("testId") String testId);

    String getCnnameByEmpuid(@Param("currentUser") String currentUser);

    void deleteBySubjectId(@Param("subjectId") String subjectId);

    int insertQuestion(@Param("questionTestId") String questionTestId, @Param("question") Question question);
}
