package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dao.QuestionDao;
import com.ekingwin.bas.cloud.exam.dao.ScoreDao;
import com.ekingwin.bas.cloud.exam.dao.TestPaperDao;
import com.ekingwin.bas.cloud.exam.dto.ScoreToBpm;
import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.cloud.exam.dto.entity.Score;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import com.ekingwin.bas.cloud.org.dto.OrgTreeDto;
import com.ekingwin.bas.cloud.org.manager.IOrganizationManager;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Primary
@Service
public class AnswerServiceImpl implements AnswerService {

    @Override
    @Transactional
    public Map<String, Object> checkAndSaveAnswer(TestPapers test) {
        Map<String, Object> map = Maps.newHashMap();
        int score = 0;
        int count = 0;
        String currentUser = UserUtils.getCurrentUser();
        //String deptName = questionDao.getDeptName(currentUser);
        //获取word模板数据
        String post = ""; //岗位名称
        String line = "";    //所在条线
        String deptName = "";  // 朗基集团总部-控股集团总部-管理信息条线-数据流程中心-软件研发主管

        List<OrgTreeDto> treelist = organizationManager.findUserMainOrgWithFlat(currentUser);
        for (OrgTreeDto treeDto : treelist) {
            if ("3".equals(treeDto.getType())) {
                post = treeDto.getName();
            } else if ("2".equals(treeDto.getType())) {
                line = treeDto.getName();
                break;
            }
        }
        deptName = post;
        if (deptName.length() > 1) {
            deptName += "-" + line;
        } else {
            deptName = line;
        }
        String cnname = questionDao.getCnnameByEmpuid(currentUser);
        test.setDepartment(deptName == null ? "" : deptName);
        // 答题批次
        String answerBatch = UUID.randomUUID().toString().replace("-", "");
        String testId = test.getTestId();
        Integer passScore = testPaperDao.queryTestByTestId(testId).getPassScore();
        List<Question> questions = test.getQuestions();
        for (Question question : questions) {
            // 查询试卷题库对应的试题
            Question s = questionDao.queryQuestionByTestIdAndID(testId, question.getSubjectId(), question.getId());
            long type = s.getType();
            if (1 == type || 3 == type) {
                // 比较答案是否一致
                if (question.getAnswer().equals(s.getAnswer())) {
                    score += s.getSingleScore();
                    question.setSingleScore(s.getSingleScore());
                    question.setCorrect(1);
                } else {
                    question.setSingleScore(0);
                    question.setCorrect(0);
                }
                question.setAnswerBatch(answerBatch);
                question.setStuffId(currentUser);
                question.setTestId(testId);
                question.setCreateBy(currentUser);
                // 保存至已答题库内
                String answerid = UUID.randomUUID().toString().replace("-", "");
                count += questionDao.insertMyAnswer(answerid, question);
            }
            if (2 == type) {
                //提交答案
                String answer1 = question.getAnswer();
                List<String> list1 = Splitter.on("|").splitToList(answer1);
                //标准答案
                String answer2 = s.getAnswer();
                List<String> list2 = Splitter.on("|").splitToList(answer2);

                // 比较答案是否一致
                if (list1.containsAll(list2)) {
                    score += s.getSingleScore();
                    question.setSingleScore(s.getSingleScore());
                    question.setCorrect(1);
                } else {
                    question.setSingleScore(0);
                    question.setCorrect(0);
                }
                question.setAnswerBatch(answerBatch);
                question.setStuffId(currentUser);
                question.setTestId(testId);
                question.setCreateBy(currentUser);
                // 保存至已答题库内
                String answerid = UUID.randomUUID().toString().replace("-", "");
                count += questionDao.insertMyAnswer(answerid, question);
            }

        }
        Date date = new Date();
//        SimpleDateFormat df= new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        Score scoreInfo = new Score();

//        scoreInfo.setStuffId(currentUser);
        scoreInfo.setBpmId(test.getBpmId());
        scoreInfo.setStuffId(currentUser);
        scoreInfo.setStuffName(cnname);
        scoreInfo.setTestId(testId);
        scoreInfo.setTestName(test.getTestName());
        scoreInfo.setAnswerBatch(answerBatch);
        scoreInfo.setScore(score);
        scoreInfo.setDepartment(test.getDepartment());
        //合格状态：0：不合格  1：合格
        int qualified = 0;
        if (score == 0) {
            scoreInfo.setQualified(0);
        } else {
            if (score >= passScore) {
                qualified = 1;
                scoreInfo.setQualified(qualified);
            } else {
                scoreInfo.setQualified(qualified);
            }
        }
        scoreInfo.setCreateTime(date);
        // 保存分数信息
        String scoreId = UUID.randomUUID().toString().replace("-", "");
        scoreInfo.setId(scoreId.trim());
        count += scoreDao.insertScore(scoreInfo);
        if (!"bpadev".equals(profiles) && !"bpasanxia".equals(profiles) && !"bpajiucaiyun".equals(profiles)
                && !"sxdev".equals(profiles)) {
            //推送到BPM
            this.scoreToBpm(scoreInfo);
        }
        map.put("score", score);
        map.put("qualified", qualified);
        return map;
    }

    @Override
    public String scoreToBpm(Score score) {
        ScoreToBpm scoreToBpm = new ScoreToBpm();
        //考试人部门
        scoreToBpm.setBm(score.getDepartment());
        //Bpm流程id
        scoreToBpm.setBpaid(score.getBpmId());
        //本次考试成绩
        scoreToBpm.setCj(score.getScore() + "");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String data;
        data = df.format(score.getCreateTime());
        //考试结束试卷
        scoreToBpm.setKssj(data);
        //考生姓名
        scoreToBpm.setXm(score.getStuffName());
        //考生账号
        scoreToBpm.setZh(score.getStuffId());
        JSONObject json = JSONObject.fromObject(scoreToBpm);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            //拼写接口报文
            RestTemplate restTemplate = new RestTemplate();
            //向接口传递数据
            //拼写好的报文提交
            HttpEntity<JSONObject> he = new HttpEntity<JSONObject>(json, headers);
            @SuppressWarnings("rawtypes")
            ResponseEntity<Map> resultjson = restTemplate.exchange(scoreToBpmUrl, HttpMethod.POST, he, Map.class);
            Map<String, String> result1 = resultjson.getBody();
            System.out.println(result1);
        } catch (RestClientException e) {
            e.printStackTrace();
        }
        return null;
    }


    @Resource
    private QuestionDao questionDao;
    @Resource
    private ScoreDao scoreDao;
    @Resource
    private TestPaperDao testPaperDao;
    @Resource
    protected IOrganizationManager organizationManager;
    @Value("${ScoreToBpm}")
    private String scoreToBpmUrl;
    @Value("${spring.profiles.active}")
    private String profiles;
}
