package com.ekingwin.bas.cloud.exam.service;

import com.ekingwin.bas.cloud.exam.dao.QuestionDao;
import com.ekingwin.bas.cloud.exam.dto.entity.Question;
import com.ekingwin.bas.cloud.infra.utils.web.UserUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Primary
@Service
@Transactional
public class QuestionsServiceImpl implements QuestionsService {

    @Override
    public int addQuestions(List<Question> questions) {
        int count = 0;
        for (Question question : questions) {
            // 添加选项前缀 A B C D  A对应的ascii码为65
            int startChar = 65;
            String newContent = "";
            String[] questionContents = question.getQuestionContent().split("\\|");
            for (String questionContent : questionContents) {
                questionContent = (char) startChar + "、" + questionContent;
                newContent = newContent + questionContent + "|";
                startChar++;
            }
            newContent = newContent.substring(0, newContent.length() - 1);
            question.setQuestionContent(newContent);
            String id = UUID.randomUUID().toString().replace("-", "");
            question.setId(id);
            Date date = new Date();
            question.setCreateTime(date);
            question.setCreateBy(UserUtils.getCurrentUser());
            count += questionDao.save(question);
        }
        return count;
    }

    @Override
    public int addQuestion(Question question, Boolean diy) {
        // 添加选项前缀 A B C D  A对应的ascii码为65
        int startChar = 65;
        String newContent = "";
        String[] questionContents = question.getQuestionContent().split("\\|");
        for (String questionContent : questionContents) {
            if (BooleanUtils.isTrue(diy)) {
                questionContent = (char) startChar + "、" + questionContent;
            }
            newContent = newContent + questionContent + "|";
            startChar++;
        }
        newContent = newContent.substring(0, newContent.length() - 1);
        question.setQuestionContent(newContent);

        //如果是自定义试题存入未关联试卷的试题库
        if (BooleanUtils.isTrue(diy)) {
            String questionTestId = UUID.randomUUID().toString().replace("-", "");
            question.setId(questionTestId.trim());
            question.setCreateTime(new Date());
            questionDao.save(question);
        }
        String questionTestId = UUID.randomUUID().toString().replace("-", "");
        question.setCreateTime(new Date());
        // 存入关联试卷的试题库
        questionDao.insertQuestion(questionTestId, question);
        return 0;
    }

    @Override
    public int editQuestions(List<Question> questions) {
        int count = 0;
        if (questions != null && !questions.isEmpty()) {
            for (Question question : questions) {
                count += editQuestion(question);
            }
        }
        return count;
    }

    @Override
    public int editQuestion(Question question) {
        // 添加选项前缀 A B C D  A对应的ascii码为65
        int startChar = 65;
        String newContent = "";
        String[] questionContents = question.getQuestionContent().split("\\|");
        for (String questionContent : questionContents) {
            questionContent = (char) startChar + "、" + questionContent;
            newContent = newContent + questionContent + "|";
            startChar++;
        }
        newContent = newContent.substring(0, newContent.length() - 1);
        question.setQuestionContent(newContent);
        return questionDao.updateByPrimaryKeySelective(question);
    }

    @Override
    public PageInfo<Question> queryQuestionsBySubjectId(String subjectId, Integer startPage, Integer pageSize) {
        PageHelper.startPage(startPage, pageSize);
        List<Question> questions = questionDao.queryQuestionsBySubjectId(subjectId);
        return new PageInfo<>(questions);
    }

    @Resource
    private QuestionDao questionDao;
}
