package com.ekingwin.bas.cloud.exam.service;


import com.ekingwin.bas.cloud.exam.dao.ScoreDao;
import com.ekingwin.bas.cloud.exam.dto.entity.Score;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.exception.BasException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
@Primary
public class ScoreServiceImpl extends BaseService implements ScoreService {

    @Autowired
    ScoreDao scoreDao;

    /**
     * 查询考试信息
     *
     * @param query
     * @return
     */
    @Override
    public PageCriteria<Score> queryScoreInfo(QueryDTO query) throws BasException {
        try {
            Example example = buildQuery(query, Score.class);
            return query(query, () -> scoreDao.queryScore(example), Score.class);
        } catch (Exception e) {
            throw new BasException(e.getMessage());
        }
    }

    @Override
    public boolean save(Score object) throws BasException {
        return false;
    }

    @Override
    public boolean delete(String id) throws BasException {
        return false;
    }

    @Override
    public PageCriteria<Score> query(QueryDTO query) throws BasException {
        return null;
    }

    @Override
    public Score get(String id) throws BasException {
        return null;
    }
}
