package com.ekingwin.bas.cloud.exam.web;

import com.ekingwin.bas.cloud.exam.dto.BackResult;
import com.ekingwin.bas.cloud.exam.dto.QueryTestVO;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.exam.service.AnswerService;
import com.ekingwin.bas.cloud.exam.service.TestPaperService;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Api(tags = "答题接口")
@Controller
@RestController
@RequestMapping("/exam/answer")
public class AnswerController {

    /**
     * 答题
     */
    @ApiOperation("提交试卷并计算分数")
    @PostMapping("/answerTest")
    public BackResult checkAndSaveAnswer(@RequestBody TestPapers test) {
//        if (profiles.contains("longey")) {
//            String userName = WebUtils.getRequest().getParameter("username");
//            if (StringUtils.isBlank(userName)) {
//                userName = (String) WebUtils.getRequest().getSession().getAttribute("ssoclientagent.user");
//            }
//            WebUtils.getRequest().getSession().setAttribute("userid", userName);
//        }
        if (test == null || test.getQuestions() == null) {
            return new BackResult(400, "试卷为空");
        }
        Map<String, Object> res = answerService.checkAndSaveAnswer(test);
        return new BackResult(200, "答题成功", res);
    }

    /**
     * 查询我的试卷
     */
    @ApiOperation("查找自己所有的试卷")
    @GetMapping("/queryMyAllTest")
    public BackResult queryMyAllTest() {
//        if (profiles.contains("longey")) {
//            String userName = WebUtils.getRequest().getParameter("username");
//            if (StringUtils.isBlank(userName)) {
//                userName = (String) WebUtils.getRequest().getSession().getAttribute("ssoclientagent.user");
//            }
//            WebUtils.getRequest().getSession().setAttribute("userid", userName);
//        }

        List<TestPapers> tests = testPaperService.queryMyAllTest();
        return new BackResult(200, "", tests);
    }

    /**
     * 查询试卷详细信息
     */
    @ApiOperation("试卷详细信息")
    @PostMapping("/queryTestDetails")
    public BackResult queryTestDetails(@RequestBody QueryTestVO queryTestVO, @RequestParam(required = false) String username) {
//        if (profiles.contains("longey")) {
//            String userName = WebUtils.getRequest().getParameter("username");
//            if (StringUtils.isBlank(userName)) {
//                userName = (String) WebUtils.getRequest().getSession().getAttribute("ssoclientagent.user");
//            }
//            WebUtils.getRequest().getSession().setAttribute("userid", userName);
//        }

        if (queryTestVO == null) {
            return new BackResult(400, "查询条件为空");
        }
        TestPapers test = testPaperService.queryTestDetails(queryTestVO);
        return new BackResult(200, "", test);
    }

    @Autowired
    AnswerService answerService;
    @Autowired
    TestPaperService testPaperService;

//    @Value("${spring.profiles.active}")
//    private String profiles;
}
