package com.ekingwin.bas.cloud.exam.web;

import com.ekingwin.bas.cloud.exam.dto.BackResult;
import com.ekingwin.bas.cloud.exam.dto.entity.Score;
import com.ekingwin.bas.cloud.exam.dto.entity.TestPapers;
import com.ekingwin.bas.cloud.exam.service.ScoreService;
import com.ekingwin.bas.cloud.exam.service.TestPaperService;
import com.ekingwin.bas.cloud.infra.dto.QueryDTO;
import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import com.ekingwin.bas.cloud.infra.web.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Api(tags = "试卷接口")
@Controller
@RestController
@RequestMapping("/exam/test")
public class TestPaperController extends BaseController {
    /**
     * 创建试卷
     *
     * @return
     */
    @ApiOperation("创建试卷")
    @PostMapping("/createTest")
    public BackResult createTest(@RequestBody TestPapers test) {
        if (test == null || test.getQuestions() == null) {
            return new BackResult(400, "创建试卷为空");
        }
        int res = testPaperService.createTest(test);
        if (res > 0) {
            return new BackResult(200, "创建试卷成功");
        }
        return new BackResult(400, "创建试卷失败");
    }

    /**
     * 查看成绩
     *
     * @param query
     * @return
     */
    @ApiOperation("查看考试成绩")
    @RequestMapping(value = "/queryScoreInfo", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public BackResult queryScoreInfo(@RequestBody(required = false) QueryDTO query) {
        try {
            PageCriteria<Score> result = scoreService.queryScoreInfo(query);
            return BackResult.successResponse(200, "查询成功", result);
        } catch (Exception e) {
            e.printStackTrace();
            return BackResult.successResponse(500, "查询失败", e.getMessage());
        }
    }

    /**
     * 删除试卷
     *
     * @param ids
     * @return
     */
    @ApiOperation("删除试卷")
    @GetMapping("/deleteTestPapers/{ids}")
    public BackResult deleteTestPapers(@PathVariable("ids") String ids) {
        if (StringUtils.isBlank(ids)) {
            return new BackResult(400, "删除数据不能为空");
        }
        int res = testPaperService.deleteTestPapers(ids);
        if (res > 0) {
            return new BackResult(200, "删除成功");
        }
        return new BackResult(400, "删除失败");
    }

    /**
     * 条件查询试卷
     *
     * @param query
     * @return
     */
    @ApiOperation("查询试卷")
    @PostMapping(value = "/queryTestPapers", produces = "application/json;charset=UTF-8")
    public BackResult queryTestPapers(@RequestBody(required = false) QueryDTO query) {
        try {
            PageCriteria<TestPapers> testPapersPageInfo = testPaperService.queryTestPapers(query);
            return BackResult.successResponse(200, "查询成功", testPapersPageInfo);
        } catch (Exception e) {
            e.printStackTrace();
            return BackResult.successResponse(500, "查询失败", e.getMessage());
        }
    }

    @ApiOperation("根据试卷id查询关联的试题")
    @GetMapping("/getTestPapersDetailsInfo/{id}")
    public BackResult getTestPapersDetailsInfo(@PathVariable("id") String id) {
        if (StringUtils.isBlank(id)) {
            return new BackResult(400, "查询数据不能为空");
        }
        TestPapers testPapers = testPaperService.getTestPapersDetailsInfo(id);
        if (null != testPapers) {
            return new BackResult(200, "查询成功", testPapers);
        } else {
            return new BackResult(500, "未查询到数据");
        }

    }

    /**
     * 修改试卷
     *
     * @return
     */
    @ApiOperation("修改试卷")
    @PostMapping("/editTest")
    public BackResult editTest(@RequestBody TestPapers test) {
        if (test == null || test.getQuestions() == null) {
            return new BackResult(400, "修改试卷为空");
        }
        for (int i = 0; i < test.getQuestions().size(); i++) {
            if (test.getQuestions().get(i).getAnswer() == null || test.getQuestions().get(i).getAnswer().length() == 0) {
                return new BackResult(400, "请填写试卷参考答案");
            }
            if (test.getQuestions().get(i).getSingleScore() == 0) {
                return new BackResult(400, "请填写试卷分数");
            }
        }
        int res = testPaperService.editTest(test);
        if (res > 0) {
            return new BackResult(200, "修改试卷成功");
        }
        return new BackResult(400, "修改试卷失败");
    }

    @Autowired
    private TestPaperService testPaperService;
    @Autowired
    private ScoreService scoreService;
}
