package com.ekingwin.bas.cloud.exam;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.common.ResultUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.spring.annotation.MapperScan;

/**
 * demo项目，作为演示使用，各个项目可以参照改demo来构建启动项目，
 * 不要直接使用该项目进行开发，需要参考该项目的配置，重新创建一个新的项目进行开发
 *
 * @author chenjb
 */
@EnableDiscoveryClient
@RefreshScope
@RestController
@SpringBootApplication(exclude = DruidDataSourceAutoConfigure.class)
@ComponentScan({"com.ekingwin.bas.cloud"})
@MapperScan({"com.ekingwin.bas.cloud.**.dao"})
@EnableTransactionManagement
@EnableCaching
@ServletComponentScan(basePackages = "com.ekingwin.bas.cloud")
public class DemoServiceApplication extends SpringBootServletInitializer implements WebApplicationInitializer {

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(DemoServiceApplication.class);
    }

    public static void main(String[] args) {
        SpringApplication.run(DemoServiceApplication.class, args);
    }

    @GetMapping(value = "/get/{id}")
    public BaseResult<String> get(@PathVariable String id) {
        String result = id + ":" + prop;
        return ResultUtils.build(result);
    }

    @Value("${test}")
    private String prop;
}
