package com.ekingwin.bas.cloud.protal.web;

import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.protal.dto.AdvertiseListDto;
import com.ekingwin.bas.cloud.protal.dto.SalesListDto;
import com.ekingwin.bas.cloud.protal.service.ICommodityManagementService;
import com.ekingwin.bas.cloud.protal.vo.*;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/CommodityManagement")
@Api(tags = "商品管理", description = "商品管理", value = "商品管理")
public class CommodityManagementController {

    @Autowired
    private ICommodityManagementService commodityManagementService;

    @PostMapping(value = "/SalesList")
    @ApiOperation(value = "销售量排行榜", notes = "销售量排行榜")
    public Result SalesList(@RequestBody SalesListVo salesListVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.SalesList(salesListVo);
        return  Result.ok(pageInfo);
    }
    @PostMapping(value = "/TheHomepage")
    @ApiOperation(value = "销售量排行榜首页显示", notes = "销售量排行榜首页显示")
    public Result TheHomepage(@RequestBody List<SalesListDto> salesListDto) throws Exception{
        return commodityManagementService.TheHomepage(salesListDto);

    }
    @PostMapping(value = "/GoodsClassify")
    @ApiOperation(value = "销售量排行榜商品分类", notes = "销售量排行榜商品分类")
    public Result GoodsClassify(@RequestBody GoodsClassifyVo goodsClassifyVo) throws Exception{
        return commodityManagementService.GoodsClassify(goodsClassifyVo);
    }

    @PostMapping(value = "/InvoiceShipAddressList")
    @ApiOperation(value = "开票信息和收货地址列表接口搜索", notes = "开票信息和收货地址列表接口搜索")
    public Result InvoiceShipAddressList(@RequestBody InvoiceShipAddressListVo invoiceShipAddressListVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.InvoiceShipAddressList(invoiceShipAddressListVo);
        return  Result.ok(pageInfo);
    }

    @PostMapping(value = "/InvoiceShipAddressAddCompany")
    @ApiOperation(value = "开票信息和收货地址列表接口新增中的子接口查询公司名", notes = "开票信息和收货地址列表接口新增中的子接口查询公司名")
    public Result InvoiceShipAddressAddCompany(@RequestBody InvoiceShipAddressListVo invoiceShipAddressListVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.InvoiceShipAddressAddCompany(invoiceShipAddressListVo);
        return  Result.ok(pageInfo);
    }

    @PostMapping(value = "/invoiceShipAddressAdd")
    @ApiOperation(value = "开票信息和收货地址列表接口新增", notes = "开票信息和收货地址列表接口新增")
    public Result invoiceShipAddressAdd(@RequestBody InvoiceShipAddressAddVo shipAddressAddVo) throws Exception{
       return commodityManagementService.invoiceShipAddressAdd(shipAddressAddVo);
    }
    @PostMapping(value = "/invoiceShipAddressUpdate")
    @ApiOperation(value = "开票信息和收货地址列表接口编辑", notes = "开票信息和收货地址列表接口编辑")
    public Result invoiceShipAddressUpdate(@RequestBody InvoiceShipAddressAddVo shipAddressAddVo) throws Exception{
        return commodityManagementService.invoiceShipAddressUpdate(shipAddressAddVo);
    }

    @PostMapping(value = "/invoiceShipAddressDelete")
    @ApiOperation(value = "开票信息和收货地址列表接口删除", notes = "开票信息和收货地址列表接口删除")
    public Result invoiceShipAddressDelete(@RequestBody InvoiceShipAddressAddVo shipAddressAddVo) throws Exception{
        return commodityManagementService.invoiceShipAddressDelete(shipAddressAddVo);
    }

    @PostMapping(value = "/AdvertiseList")
    @ApiOperation(value = "广告位列表查询接口", notes = "广告位列表查询接口")
    public Result AdvertiseList(@RequestBody AdvertiseListVo advertiseListVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.AdvertiseList(advertiseListVo);
        return Result.ok(pageInfo);
    }
    @PostMapping(value = "/AdvertiseAddCode")
    @ApiOperation(value = "广告位列表新增子接口广告位编号查询", notes = "广告位列表新增子接口广告位编号查询")
    public Result AdvertiseAddCode() throws Exception{
        return commodityManagementService.AdvertiseAddCode();
    }

    @PostMapping(value = "/AdvertiseAdd")
    @ApiOperation(value = "广告位列表新增", notes = "广告位列表新增")
    public Result AdvertiseAdd(@RequestBody AdvertiseAddVo advertiseAddVo) throws Exception{
        return commodityManagementService.AdvertiseAdd(advertiseAddVo);
    }

    @PostMapping(value = "/AdvertiseUpdate")
    @ApiOperation(value = "广告位列表编辑", notes = "广告位列表编辑")
    public Result AdvertiseUpdate(@RequestBody AdvertiseAddVo advertiseAddVo) throws Exception{
        return commodityManagementService.AdvertiseUpdate(advertiseAddVo);
    }

    @PostMapping(value = "/AdvertiseDelete")
    @ApiOperation(value = "广告位列表删除", notes = "广告位列表删除")
    public Result AdvertiseDelete(@RequestBody AdvertiseAddVo advertiseAddVo) throws Exception{
        return commodityManagementService.AdvertiseDelete(advertiseAddVo);
    }

    @PostMapping(value = "/GoodsClassifys")
    @ApiOperation(value = "商品库商品分类", notes = "商品库商品分类")
    public Result GoodsClassifys(@RequestBody GoodsClassifyVo goodsClassifyVo) throws Exception{
        return commodityManagementService.GoodsClassifys(goodsClassifyVo);
    }

    @GetMapping(value = "/GoodsQueryOne/{id}")
    @ApiOperation(value = "通威商品库查看", notes = "通威商品库查看")
    public Result GoodsQueryOne(@PathVariable(value = "id") Integer id) throws Exception{
        return commodityManagementService.GoodsQueryOne(id);
    }
    @PostMapping(value = "/GoodsBrandList")
    @ApiOperation(value = "通威商品库查询", notes = "通威商品库查询")
    public Result GoodsBrandList(@RequestBody GoodsBrandListVo goodsBrandListVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.GoodsBrandList(goodsBrandListVo);
        return  Result.ok(pageInfo);
    }
    @PostMapping(value = "/MaterielImport")
    @ApiOperation(value = "商品库新增中基本信息子接口的商品名称查询", notes = "商品库新增中基本信息子接口的商品名称查询")
    public Result MaterielImport(@RequestBody MaterielImportVo materielImportVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.MaterielImport(materielImportVo);
        return  Result.ok(pageInfo);
    }

    @PostMapping(value = "/SupplierMateriel")
    @ApiOperation(value = "商品库新增中基本信息子接口的供应商名称查询", notes = "商品库新增中基本信息子接口的供应商名称查询")
    public Result SupplierMateriel(@RequestBody SupplierMaterielVo supplierMaterielVo) throws Exception{
        PageInfo pageInfo = commodityManagementService.querySupplierMateriel(supplierMaterielVo);
        return  Result.ok(pageInfo);
    }

    @PostMapping(value = "/querySalesareaName")
    @ApiOperation(value = "商品库新增销售区域查询", notes = "商品库新增销售区域查询")
    public Result querySalesareaName(@RequestBody GoodsClassifyVo goodsClassifyVo) throws Exception{
        return commodityManagementService.querySalesareaName(goodsClassifyVo);
    }

    @PostMapping(value = "/GoodsBrandSoldOut")
    @ApiOperation(value = "商品库更改状态为下架", notes = "商品库更改状态为下架")
    public Result GoodsBrandSoldOut(@RequestBody GoodsBrandSoldOutVo goodsBrandSoldOutVo) throws Exception{
        return commodityManagementService.GoodsBrandSoldOut(goodsBrandSoldOutVo);
    }

    @PostMapping(value = "/GoodsBrandOnTheAudit")
    @ApiOperation(value = "商品库更改状态为上架发起", notes = "商品库更改状态为上架发起")
    public Result GoodsBrandOnTheAudit(@RequestBody GoodsBrandOnTheAuditVo goodsBrandSoldOutVo) throws Exception{
        return commodityManagementService.GoodsBrandOnTheAudit(goodsBrandSoldOutVo);
    }

    @PostMapping(value = "/goodsUpOrDownProcessRest_PS")
    @ApiOperation(value = "商品库更改状态为上架审批回传", notes = "商品库更改状态为上架审批回传")
    public Result goodsUpOrDownProcessRest_PS(Map<String,Object> map) throws Exception{
        return commodityManagementService.goodsUpOrDownProcessRest_PS(map);
    }

    @PostMapping(value = "/GoodsBrandAdd")
    @ApiOperation(value = "通威商品库新增", notes = "通威商品库新增")
    public Result GoodsBrandAdd(@RequestBody GoodsBrandAddVo goodsBrandAddVo) throws Exception{
        return commodityManagementService.GoodsBrandAdd(goodsBrandAddVo);
    }

    @PostMapping(value = "/GoodsBrandUpdate")
    @ApiOperation(value = "通威商品库编辑", notes = "通威商品库编辑")
    public Result GoodsBrandUpdate(@RequestBody GoodsBrandAddVo goodsBrandAddVo) throws Exception{
        return commodityManagementService.GoodsBrandUpdate(goodsBrandAddVo);
    }

    @PostMapping(value = "/FileUploaded")
    @ApiOperation(value = "图片上传", notes = "图片上传")
    public Result FileUploaded(@RequestParam(value = "file") MultipartFile file, @RequestParam(value = "name", required=false) String name) throws Exception {

        Map<String, String[]> fileMeta = WebUtils.getRequest().getParameterMap();
        if(StringUtils.isEmpty(name)){
            name = file.getOriginalFilename();
        }
        return commodityManagementService.FileUploaded(file.getInputStream(), name, fileMeta);
    }
}
