package com.ekingwin.bas.cloud.protal.web;

import com.ekingwin.bas.cloud.protal.dto.SupplierListMessageDto;
import com.ekingwin.bas.cloud.protal.dto.SupplierPageMessageDto;
import com.ekingwin.bas.cloud.protal.service.ISupplierListMessageService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@RestController
@RequestMapping(value = "/supplier")
@Api(tags = "供应商列表全部信息", description = "供应商列表全部信息", value = "供应商列表全部信息")
public class SupplierListMessageController {

    @Autowired
    private ISupplierListMessageService supplierListMessageService;
    /**
     * 查询供应商列表在售商品全部信息
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/supplierListMessage")
    @ApiOperation(value = "查询供应商列表在售商品全部信息", notes = "查询供应商列表在售商品全部信息")
    public Result querySupplierListMessageAll() throws Exception{
        List<SupplierListMessageDto> supplierListMessageDto = supplierListMessageService.querySupplierListMessageAll();
        return  Result.ok(supplierListMessageDto);
    }
    /**
     * 根据供应商名称或者编码模糊查询供应商信息
     * @param
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/supplierMessage")
    @ApiOperation(value = "根据供应商名称或者编码模糊查询供应商信息", notes = "根据供应商名称或者编码模糊查询供应商信息")
    public Result querySupplierBasicMessageByFullnameOrNum(@RequestBody SupplierPageMessageDto supplierPageMessageDto) throws Exception{
        PageInfo pageInfo = supplierListMessageService.querySupplierBasicMessageByFullnameOrNum(supplierPageMessageDto);
        return  Result.ok(pageInfo);
    }
}

