package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.entity.IpGoodsLogs;
import com.ekingwin.bas.cloud.entity.IpGoodsLogsWithBLOBs;
import com.ekingwin.bas.cloud.vo.IpGoodsLogsVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpGoodsLogsMapper {
    int deleteByPrimaryKey(Integer id);

    int insert(IpGoodsLogsWithBLOBs record);

    int insertSelective(IpGoodsLogsWithBLOBs record);

    IpGoodsLogsWithBLOBs selectByPrimaryKey(Integer id);

    int updateByPrimaryKeySelective(IpGoodsLogsWithBLOBs record);

    int updateByPrimaryKeyWithBLOBs(IpGoodsLogsWithBLOBs record);

    int updateByPrimaryKey(IpGoodsLogs record);

    /**
     * 根据商品Id获取操作记录
     * @param goodId
     * @return
     */
    List<IpGoodsLogsWithBLOBs> getDetailByGoodsid(Long goodId);


    /**
     * 获取商品的操作记录
     * @param goodsId
     * @return
     */
    List<IpGoodsLogsVo> getLogByGoodsId(Long goodsId);
}