package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.entity.IpGoodsPrice;
import com.ekingwin.bas.cloud.entity.IpGoodsPriceProcess;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @program: rcworkspace
 * @description:商品价格
 * @author: zhangjie
 * @create: 2019-06-27 16:07
 **/
@Repository
public interface IpGoodsPriceProcessMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpGoodsPriceProcess record);

    int insertSelective(IpGoodsPriceProcess record);

    IpGoodsPriceProcess selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpGoodsPriceProcess record);

    int updateByPrimaryKey(IpGoodsPriceProcess record);

    /**
     * 根据商品ID删除商品价格
     * @param goodsId
     * @return
     */
    int deleteByGoodsid(Long goodsId);


    /**
     * 根据商品id获取商品价格
     * @param goodsId
     * @return
     */
    List<IpGoodsPriceProcess> getDetailByGoodsid(Long goodsId);
}