package com.ekingwin.bas.cloud.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-26 10:12
 **/
@Data
@ApiModel("solr 查询调用实体")
public class IpGoodsSolrDto implements Serializable {

    @ApiModelProperty(value = "关键词",required = true)
    private String jiucaiyun_keywords;
    @ApiModelProperty(value = "分类id",required = true)
    private String jiucaiyun_catalog;

    @ApiModelProperty(value = "品牌",required = true)
    private String jiucaiyun_brand;

    @ApiModelProperty(value = "商品类型",required = true)
    private String jiucaiyun_type;

    @ApiModelProperty(value = "规格",required = true)
    private String jiucaiyun_model;

    @ApiModelProperty(value = "价格",required = true)
    private String jiucaiyun_price;

    @ApiModelProperty(value = "销量",required = true)
    private String jiucaiyun_salesvolume;

    @ApiModelProperty(value = "/ 销售限制",required = true)
    private String jiucaiyun_permission;

    @ApiModelProperty(value = "// 价格排序 asc升序，desc降序",required = true)
    private String jiucaiyun_price_order;

    @ApiModelProperty(value = "// 销量排序，按降序",required = true)
    private String jiucaiyun_salesvolume_order;

    @ApiModelProperty(value = "供应商ID",required = true)
    private String jiucaiyun_supplierid;


    @ApiModelProperty(value = "供应商编码",required = true)
    private String jiucaiyun_suppliernum;

    @ApiModelProperty(value = "客户等级",required = true)
    private String jiucaiyun_level;

    @ApiModelProperty(value = "区分是项目还是个人商品 XM GR",required = true)
    private String jiucaiyun_ftnpjc;

    @ApiModelProperty(value = "区分商品类型 HD 活动 常规CG",required = true)
    private String jiucaiyun_ftnpconfiguration;

    private Integer pageNo = 1;
    private Integer pageSize = 10;
    private Integer startRow;
}
