package com.ekingwin.bas.cloud.goods.web;

import com.ekingwin.bas.cloud.dto.GoodsGetDetailDto;
import com.ekingwin.bas.cloud.dto.IpGoodsSearchDto;
import com.ekingwin.bas.cloud.goods.dao.entity.Supplier;
import com.ekingwin.bas.cloud.goods.dao.entity.SupplierGoods;
import com.ekingwin.bas.cloud.goods.dto.SupplierGoodsDetail;
import com.ekingwin.bas.cloud.goods.dto.SupplierGoodsDto;
import com.ekingwin.bas.cloud.goods.service.SupplierGoodsService;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.common.ResultUtils;
import com.ekingwin.bas.cloud.service.IpGoodFootService;
import com.ekingwin.bas.cloud.service.IpGoodsDraftService;
import com.ekingwin.bas.cloud.service.IpGoodsService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping(value = "/supplierGoods/")
@Api(tags = "首页供应商在售商品接口", description = "首页供应商在售商品接口", value = "首页供应商在售商品接口")
public class SupplierGoodsController {
    @Autowired
    private SupplierGoodsService supplierGoodsService;
    @Autowired
    private IpGoodFootService ipGoodFootService;
    @Autowired
    private IpGoodsService ipGoodsService;
//    @ApiOperation(value = "查询供应商在售商品", notes = "查询供应商在售商品")
//    @PostMapping(value = "/getsSolrData")
//    public Result getsSolrData(@RequestBody IpGoodsSearchDto ipGoodsSearchDto) throws  Exception{
//        String jsonObject =supplierGoodsService.getsQueryData(ipGoodsSearchDto);
//        return  Result.ok(jsonObject);
//    }
    @ApiOperation(value = "查询供应商在售商品", notes = "查询供应商在售商品")
    @PostMapping(value = "/queryData")
    public BaseResult queryData(@RequestBody SupplierGoodsDto supplierGoodsDto) throws  Exception{

        Supplier supplier= supplierGoodsService.queryData(supplierGoodsDto);
        return  ResultUtils.build(supplier);
    }

    @ApiOperation(value = "获取供应商商品详情", notes = "获取供应商商品详情",response = GoodsDeatilVo.class)
    @PostMapping(value = "/getGoodsDetail")
    public Result getGoodsDetail(@RequestBody SupplierGoodsDetail  supplierGoodsDetail) throws  Exception{
        GoodsDeatilVo goodsDeatilVo=supplierGoodsService.getGoodsDetail(supplierGoodsDetail);
        return  Result.ok(goodsDeatilVo);
    }


}
