package com.ekingwin.bas.cloud.goodsMge.service.impl;

import com.ekingwin.bas.cloud.goodsMge.dao.GoodsDetailDao;
import com.ekingwin.bas.cloud.goodsMge.dto.*;
import com.ekingwin.bas.cloud.goodsMge.service.GoodsDetailService;
import com.ekingwin.bas.cloud.goodsMge.util.ReadFileUtil;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.*;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName GoodsDetailServiceImpl.java
 * @Description TODO
 * @createTime 2020/3/23 9:15
 */
@Service
@Primary
public class GoodsDetailServiceImpl implements GoodsDetailService {
    @Autowired
    private GoodsDetailDao goodsDetailDao;
    @Value("${jd.imgbase0}")
    private String imgbase0;
    @Value("${baseurl}")
    private String baseurl;
    @Value("${txt.url}")
    private String txturl;
    @Value("${dataSourceName}")
    private String twmallbas;

    @Override
    public Result getGoodsDetail(String id, String companyid) {
        List<GoodsMgeDto> goodsMgeDtoList=goodsDetailDao.getGoodsDetail(id);
        if(goodsMgeDtoList !=null && !goodsMgeDtoList.isEmpty()){
            for(int i=0;i<goodsMgeDtoList.size();i++){
                if(StringUtils.isNotEmpty(goodsMgeDtoList.get(i).getDescription())){

                }
//                if(StringUtils.isNotEmpty(goodsMgeDtoList.get(i).getAttachmentpath())){
                    //result[i].attachmentpath = result[i].attachmentpathb
                    //result[i]是原node代码中sql返回的，这里是指goodsMgeDtoList，node代码这里有坑，不知道怎么填
 //               }
            }
            if(StringUtils.isNotEmpty(goodsMgeDtoList.get(0).getSupplierid())){
                String supplierid=goodsMgeDtoList.get(0).getSupplierid();
                List<SupplierDto> SupplierDtoList=goodsDetailDao.getSupplier(supplierid);
                if(SupplierDtoList !=null && !SupplierDtoList.isEmpty()){
                    goodsMgeDtoList.get(0).setSupplier(SupplierDtoList.get(0).getFullname());
                    List<SupplierDto> SupplierList=new ArrayList<>();
                    SupplierList.add(SupplierDtoList.get(0));
                    goodsMgeDtoList.get(0).setSupplierInfo(SupplierList);
                }
            }
        }
        List<GoodsMgeDto> goodsMgeList=goodsDetailDao.getGoods(id);
        if(goodsMgeList!=null && !goodsMgeList.isEmpty()){
            if(StringUtils.isNotEmpty(goodsMgeList.get(0).getWareid())){
                //wareid不为空，存在京东物品
                //获取京东物品
                List<UrlImgidDto> urlImgidDtoList=goodsDetailDao.getJdGoods(id);
                Map<String,Object> urlMap=new HashMap<>();
                Map<String,Object> imgidMap=new HashMap<>();
                List<Map<String,Object>> urlList=new ArrayList<>();
                List<Map<String,Object>> imgidList=new ArrayList<>();
                for(int i=0;i<urlImgidDtoList.size();i++) {
                    urlMap.put("url",urlImgidDtoList.get(i).getUrl());
                    imgidMap.put("imgid",urlImgidDtoList.get(i).getImgid());
                    urlList.add(urlMap);
                    imgidList.add(imgidMap);
                    goodsMgeDtoList.get(0).setUrl(urlList);
                    goodsMgeDtoList.get(0).setImgid(imgidList);
                }
            }else{//处理非京东商品
                List<UrlImgidDto> urlImgidDtoList= goodsDetailDao.getNotJdGoods(id,baseurl);
                Map<String,Object> urlMap=new HashMap<>();
                Map<String,Object> imgidMap=new HashMap<>();
                List<Map<String,Object>> urlList=new ArrayList<>();
                List<Map<String,Object>> imgidList=new ArrayList<>();
                for(int i=0;i<urlImgidDtoList.size();i++) {
                    urlMap.put("url",urlImgidDtoList.get(i).getUrl());
                    imgidMap.put("imgid",urlImgidDtoList.get(i).getImgid());
                    urlList.add(urlMap);
                    imgidList.add(imgidMap);
                    goodsMgeDtoList.get(0).setUrl(urlList);
                    goodsMgeDtoList.get(0).setImgid(imgidList);
                }
            }
        }else{
            return Result.error("商品不存在");
        }
        GoodsMgeDto goodsMgeDto=new GoodsMgeDto();
        goodsMgeDto =goodsDetailDao.getSalesVolume(id);
        if(StringUtils.isNotEmpty(goodsMgeDto.getSalesvolume())){
            goodsMgeDtoList.get(0).setSalesvolume(goodsMgeDto.getSalesvolume());
        }else{
            BigInteger n=BigInteger.valueOf(0);
            goodsMgeDtoList.get(0).setSalesvolume(n);
        }
         List<DescribeListDto> describeList= goodsDetailDao.describeList(id);
         List<Map<String,Object>> list=new ArrayList<>();
         Map<String,Object> map=new HashMap<>();
        if(describeList!=null && !describeList.isEmpty()){
            for(int i=0;i<describeList.size();i++){
                map.put(describeList.get(i).getDescribeName(),describeList.get(i).getDescribeContent());
                list.add(map);
                goodsMgeDtoList.get(0).setDescribeList(list);
            }
        }
        List<GoodsLogsDto> goodsLogsDtoList=goodsDetailDao.getGoodsLogs(id);
        if(goodsLogsDtoList !=null && !goodsLogsDtoList.isEmpty()){
            goodsMgeDtoList.get(0).setUpdownhistory(goodsLogsDtoList);
        }
        if(StringUtils.isNotEmpty(goodsMgeDtoList.get(0).getDetails())){
            String txtUrl=txturl+goodsMgeDtoList.get(0).getDetails();
            String data=ReadFileUtil.ReadTxtFile(txtUrl);
//            if(StringUtils.isNotEmpty(data)){
                goodsMgeDtoList.get(0).setDetails(data);
//            }
        }
        if(StringUtils.isNotEmpty(companyid)){
            String ids=goodsDetailDao.getsalesareas(companyid,twmallbas);
            if(StringUtils.isNotEmpty(ids)){
                goodsMgeDtoList.get(0).setSalesarea(ids);
            }
        }
        //校验商品是否用加入购物车的权限
        List<GoodsLogsDto> authoritymark=goodsDetailDao.getauthoritymark(id,goodsMgeDtoList.get(0).getSalesarea());
        if(authoritymark!=null && !authoritymark.isEmpty()){
            goodsMgeDtoList.get(0).setAuthoritymark("Y");
        }else{
            goodsMgeDtoList.get(0).setAuthoritymark("N");
        }
        return Result.ok(goodsMgeDtoList);
    }

    @Override
    public DetailGradeDto getGoodsDetailGrade(String id, int pagenum, int pagesize) {
        DetailGradeDto detailGradeDto =new DetailGradeDto();
        DetailGradeViewsDto detailGradeViewsDto =new DetailGradeViewsDto();
        int start=(pagenum-1)*pagesize;
        List<ReceiptDto> receiptDtoList=goodsDetailDao.getReceiptList(id,twmallbas,start,pagesize);
        int goodsreviewsgrade=0;
        int count=0;
        int reviewslength=  receiptDtoList.size();
        if(receiptDtoList!=null && !receiptDtoList.isEmpty()){
            for(int i=0;i<receiptDtoList.size();i++){
                goodsreviewsgrade +=Integer.parseInt(receiptDtoList.get(i).getTotalgrade())*1;
            }
            goodsreviewsgrade=Integer.parseInt(new DecimalFormat("0").format(Math.rint(goodsreviewsgrade/reviewslength)));
            detailGradeViewsDto.setGoodsreviewsgrade(goodsreviewsgrade);
            int goodsid=receiptDtoList.get(count).getGoodid();
            List<UrlImgidDto> UrlImgidList=goodsDetailDao.getUrlImgid(goodsid,twmallbas,baseurl);
            if(UrlImgidList!=null && !UrlImgidList.isEmpty()){
                for(int i=0;i<UrlImgidList.size();i++){
                    receiptDtoList.get(count).setUrlid(UrlImgidList.get(i).getUrl());
                }
                count++;
            }else{
                count++;
            }
        }
        detailGradeViewsDto.setGoodsreviews(receiptDtoList);
        detailGradeDto.setBody(detailGradeViewsDto);
        detailGradeDto.setCount(count);
        return detailGradeDto;
    }
}
