package com.ekingwin.bas.cloud.protal.dao;

import com.ekingwin.bas.cloud.protal.dto.*;
import com.ekingwin.bas.cloud.protal.vo.HomepageQueryVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface HomepageSearchMapper {
    /**
     * 查询总个数
     * @param homepageQueryVo
     * @return
     */
    HomepageQueryListDto HomepageQuerytotalnum(HomepageQueryVo homepageQueryVo);

    /**
     * 查询首页搜索分类
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryCategoryDto> HomepageQueryCategory(HomepageQueryVo homepageQueryVo);

    /**
     * 查询首页搜索品牌
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryBrandsDto> HomepageQueryBrands(HomepageQueryVo homepageQueryVo);


    /**
     * 查询首页搜索型号
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryModelDto> HomepageQueryModel(HomepageQueryVo homepageQueryVo);

    /**
     * 首页搜索商品分类
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryMaterialclassifyDto> HomepageQueryMaterialclassify(HomepageQueryVo homepageQueryVo);


    /**
     * 首页搜索商品全部信息
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryGoodsListDto> HomepageQueryGoodsList(HomepageQueryVo homepageQueryVo);

    /**
     * 首页搜索京东或者非京东
     * @param homepageQueryVo
     * @return
     */
    List<HomepageQueryTypeDto> HomepageQueryType(HomepageQueryVo homepageQueryVo);
}
