package com.ekingwin.bas.cloud.protal.service.Impl;

import com.ekingwin.bas.cloud.protal.dao.ProcessManagementMapper;
import com.ekingwin.bas.cloud.protal.dto.ProcessTraceDto;
import com.ekingwin.bas.cloud.protal.dto.ProcessTracelistDto;
import com.ekingwin.bas.cloud.protal.service.IProcessManagementService;
import com.ekingwin.bas.cloud.protal.vo.ProcessTraceVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;

@Primary
@Service
public class ProcessManagementServiceImpl implements IProcessManagementService {

    @Value("${dataSourceName}")
    private String acrossdatabase;
    @Value("${img.url}")
    private String url;

    @Autowired
    private ProcessManagementMapper processManagementMapper;

    /**
     * 流程上下架商品审核状态查询
     * @return
     */
    @Override
    public PageInfo queryProcessTrace(ProcessTraceVo processTraceVo) {
        PageHelper.startPage(processTraceVo.getPagenum(),processTraceVo.getPagesize());
        processTraceVo.setDatabase(acrossdatabase);
        processTraceVo.setUrl(url);
        //查询流程上下架状态信息
        List<ProcessTraceDto> processTraceDtos = processManagementMapper.queryProcessTraceAndGoods(processTraceVo);
        for (int i = 0; i < processTraceDtos.size(); i++) {
            processTraceVo.setSupplierid(processTraceDtos.get(i).getSupplierid());
            //查询上下架表以及商品表信息
            List<ProcessTracelistDto> processTracelistDtos = processManagementMapper.queryUpOrDownAndGoods(processTraceVo);
            processTraceDtos.get(i).setGoodslist(processTracelistDtos);
        }
        PageInfo pageInfo = new PageInfo<>(processTraceDtos);
        return pageInfo;
    }
}
