package com.ekingwin.bas.cloud.protal.vo;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "通威商品库新增")
public class GoodsBrandAddVo {
    //商品名称
    private String name;
    //商品编码
    private String goodsnum;
    //物料编码
    private String mdmcode;
    //商品分类
    private String FTNPFirstCategoryCode;
    private String FTNPSecondCategoryCode;
    private String FTNPThreeCategoryCode;
    private String FTNPFirstCategoryName;
    private String FTNPSecondCategoryName;
    private String FTNPThreeCategoryName;
    //商品类型
    private String materialclassify;
    //品牌
    private String brand;
    //品名
    private String brandname;
    //计量单位
    private String unit;
    //供应商
    private String supplier;
    //供应商编码
    private String suppliernum;
    //供应商id
    private String supplierid;
    //发货地点
    private String deliveryplace;
    //发票类型
    private String invoicetype;
    //税率
    private String taxrate;
    //含运费 是/否Y/N
    private String freightcharges;
    //价格类型
    private String pricetype;
    //有效期
    private String successdate;
    //交货期(天)
    private String candate;
    //todo 区间价  如果区间价选择是，单价会有价格区间，否则只选择单价  是/否Y/N
    private String isinquiry;
    //起订量
    private String minimumquantity;
    //币种
    private String currency;
    //todo 单价
    private String price;//此字段前端不传参
    private String minprice;//左边的框框
    private String maxprice;//右边的框框，当区间价选择为否时，此字段可不传参
    //销售区域id
    private String salesarea;
    //销售区域名字
    private String salesareaname;
    //原因
    private String reason;
    //备注
    private String remark;
    //商品描述
    private String description;
    //是否闲置
    private String idlegoods;
    //todo 以下字段不用传参
    //状态 默认为6，待上架
    private String state;
    //商品录入时间
    private String inputdate;
    //销量默认为0
    private Integer salesVolume;
    //当前登录人
    private String userid;
    //txt
    private String details;

    //编辑的商品id
    private Integer id;
    //物资图片
    private String urlid;
    private List<GoodsPicturesVo> goodsPicturesVos;
}
