package com.ekingwin.bas.cloud.quartz.underframe.dao;

import com.ekingwin.bas.cloud.dto.IpGoodsLogsQuartzDto;
import com.ekingwin.bas.cloud.dto.IpGoodsQuartzDto;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: UnderFrameDao
 * @Author: liujunfeng
 * @Date: 2020/1/14 11:13
 * @description:
 */
@Repository
public interface UnderFrameDao {

    /**
     * 查询失效的商品
     * @return
     */
    List<IpGoodsQuartzDto> selectGoods();


    /**
     * 将商品设置为失效
     * @param goodsId
     */
    void updateGoods(Integer goodsId);

    /**
     * 插入操作记录—商品日志表
     * @param goodsLogsQuartzDto
     */
    void saveGoodsLogs(IpGoodsLogsQuartzDto goodsLogsQuartzDto);
}
