package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.GoodsCategoryTreeDto;
import com.ekingwin.bas.cloud.dto.IpGoodsCategoryDto;
import com.ekingwin.bas.cloud.dto.SaveGoodsCategoryDto;
import com.ekingwin.bas.cloud.vo.GoodsCategoryTreeVo;
import com.ekingwin.bas.cloud.vo.IpGoodsCategoryDetailVo;
import com.ekingwin.bas.cloud.vo.IpThirdCategoryInfoVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

public interface IClassifyServie {

   //根据授权商获取物资分类
   PageInfo getThirdClassify(IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception;

   //获取商品三级分类
   List<IpGoodsCategoryDetailVo> getThirdClassifyBy(IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception;

   //获取每一级分类的详情
   IpThirdCategoryInfoVo getGoodsCategoryInfo(String categoryId) throws Exception;

   //新增修改分类信息
   void saveOrUpdateCategoryInfo(SaveGoodsCategoryDto saveGoodsCategoryDto) throws Exception;

   //删除分类信息
   void deleteCategoryInfo(String categoryId) throws Exception;

   List<IpGoodsCategoryDetailVo> getGoodsCategoryInfoByLevel(IpGoodsCategoryDto ipGoodsCategoryDto) throws Exception;



   List<GoodsCategoryTreeVo> getGoodsCategoryTree(GoodsCategoryTreeDto categoryTreeDto);

   /**
    * 获取商品分类
    * @param companyid
    * @return
    */
   List<Map<String,Object>> getAllGoodsCategInfo(String  companyid);
}
