package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.util.HttpXmlClient;
import com.ekingwin.bas.cloud.util.StringUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * 开启线程异步上架
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-01 18:13
 **/

@Component
@Scope("prototype")
public class InitSolrGoodsService implements  Runnable {

    private Logger logger = LoggerFactory.getLogger(InitSolrGoodsService.class);
    /**
     * 商品上架
     */

    private String solrAddData;

    /**
     * Getter for property 'solrAddData'.
     *
     * @return Value for property 'solrAddData'.
     */
    public String getSolrAddData() {
        return solrAddData;
    }

    /**
     * Setter for property 'solrAddData'.
     *
     * @param solrAddData Value to set for property 'solrAddData'.
     */
    public void setSolrAddData(String solrAddData) {
        this.solrAddData = solrAddData;
    }

    private Thread thread;
    private Long   busskey;

    public void start(Long busskey, InitSolrGoodsService  initSolrGoodsService) {
        this.busskey=busskey;
        thread = new Thread(initSolrGoodsService, busskey.toString());
        thread.start();
    }

    @Override
    public void run() {
        try {
            logger.info("开启商品上架线程》》》"+busskey);
            Thread.sleep(5000);
            String addDataUrl=solrAddData+"/"+busskey;
            JSONObject jsonObject = new JSONObject();
            boolean flag=false;
            String result= HttpXmlClient.post1(jsonObject.toString(),addDataUrl);
            if (StringUtils.isNotEmpty(result)){
                if ("true".equals(result)){
                    flag=true;
                }
            }

        } catch (Exception e) {
            logger.info("开启商品上架线程》》》异常"+e.getMessage());
        }finally {

        }
    }
}
