package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.IpMobileAdvertisingDto;
import com.ekingwin.bas.cloud.dto.IpMobileAdvertisingPageDto;
import com.ekingwin.bas.cloud.dto.MainGoodsDataDto;
import com.ekingwin.bas.cloud.dto.MobileAdvertisingDto;
import com.ekingwin.bas.cloud.vo.MainGoodsDataVo;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @author 许世文
 * @Date 2019/8/6 15:36
 * @Version 1.0
 **/
public interface MainGoodsDataService {

    void addMainGoodsData(MainGoodsDataDto mainGoodsDataDto);

    MainGoodsDataVo getMainGoodsData(MainGoodsDataDto mainGoodsDataDto);

    void updateMainGoodsData(MainGoodsDataDto mainGoodsDataDto);

    void deleteMainGoodsDate(MainGoodsDataDto mainGoodsDataDto);


    String addMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception;

    String updateMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception;

    void deleteMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception;

    PageInfo<MobileAdvertisingDto> queryAdvertisingList(IpMobileAdvertisingPageDto pageDto) throws Exception;

    MobileAdvertisingDto queryAdvertising(IpMobileAdvertisingPageDto pageDto) throws Exception;

    PageInfo<MobileAdvertisingDto> queryAdvertisingLogsList(IpMobileAdvertisingPageDto pageDto) throws Exception;

    PageInfo<MobileAdvertisingDto> queryAdvertise(IpMobileAdvertisingPageDto pageDto) throws Exception;

    /**
     *获取新品上架和热门采购
     * @param
     * @return List<Map<String,Object>>
     * @throws Exception
     */
    Map<String,Object> searchRecommend() throws Exception;


}
