package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpMainGoodsDataMapper;
import com.ekingwin.bas.cloud.dao.IpMainGoodsMapper;
import com.ekingwin.bas.cloud.dao.IpMobileAdvertisingLogsMapper;
import com.ekingwin.bas.cloud.dao.IpMobileAdvertisingMapper;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.IpMobileAdvertising;
import com.ekingwin.bas.cloud.entity.IpMobileAdvertisingLogs;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.service.MainGoodsDataService;
import com.ekingwin.bas.cloud.vo.MainGoodsDataVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author 许世文
 * @Date 2019/8/6 15:39
 * @Version 1.0
 **/
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class MainGoodsDataServiceImpl extends BaseService implements MainGoodsDataService {

    @Autowired
    private IpMainGoodsDataMapper ipMainGoodsDataMapper;

    @Autowired
    IpMobileAdvertisingMapper mobileAdvertisingMapper;

    @Autowired
    IpMobileAdvertisingLogsMapper mobileAdvertisingLogsMapper;
    @Autowired
    IpMainGoodsMapper ipMainGoodsMapper;

    @Value("${goods.baseurl}")
    private String basUrl;
    @Value("${dataSourceName}")
    private String basdb;
    @Value(value = "${img.url}")
    private String imgurl;

    @Override
    public void addMainGoodsData(MainGoodsDataDto mainGoodsDataDto) {
        if (mainGoodsDataDto.getTop() != null){
            if(!mainGoodsDataDto.getTop().isEmpty()&&mainGoodsDataDto.getTop().size()>0){
                int topMaxSort = ipMainGoodsDataMapper.getTopMaxSort();
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTop();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    topMaxSort +=1;
                    goodsDataDto.setSort(topMaxSort);
                }
                ipMainGoodsDataMapper.insertTopData(goodsDataDtoList);
            }
        }
        if (mainGoodsDataDto.getTopadvertiseposition() != null){
            if(!mainGoodsDataDto.getTopadvertiseposition().isEmpty()&&mainGoodsDataDto.getTopadvertiseposition().size()>0){
                int rightMaxSort = ipMainGoodsDataMapper.getRightMaxSort();
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTopadvertiseposition();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    rightMaxSort +=1;
                    goodsDataDto.setSort(rightMaxSort);
                }
                ipMainGoodsDataMapper.insertRightData(goodsDataDtoList);
            }
        }
        if (mainGoodsDataDto.getRecommend() != null){
            if(!mainGoodsDataDto.getRecommend().isEmpty()&&mainGoodsDataDto.getRecommend().size()>0){
                int middleMaxSort = ipMainGoodsDataMapper.getMiddleMaxSort();
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getRecommend();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    middleMaxSort +=1;
                    goodsDataDto.setSort(middleMaxSort);
                }
                ipMainGoodsDataMapper.insertMiddleData(goodsDataDtoList);
            }
        }
        if (mainGoodsDataDto.getPromotion() != null){
            if(!mainGoodsDataDto.getPromotion().isEmpty()&&mainGoodsDataDto.getPromotion().size()>0){
                int middleMaxSort = ipMainGoodsDataMapper.getPromotionSort();
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getPromotion();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    middleMaxSort +=1;
                    goodsDataDto.setSort(middleMaxSort);
                }
                ipMainGoodsDataMapper.insertPromotionData(goodsDataDtoList);
            }
        }
        if (mainGoodsDataDto.getSeconds() != null){
            if(!mainGoodsDataDto.getSeconds().isEmpty()&&mainGoodsDataDto.getSeconds().size()>0){
                int middleMaxSort = ipMainGoodsDataMapper.getSecondsSort();
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getSeconds();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    middleMaxSort +=1;
                    goodsDataDto.setSort(middleMaxSort);
                }
                ipMainGoodsDataMapper.insertSecondsData(goodsDataDtoList);
            }
        }
    }

    @Override
    public MainGoodsDataVo getMainGoodsData(MainGoodsDataDto mainGoodsDataDto) {
        MainGoodsDataVo mainGoodsDataVo = new MainGoodsDataVo();
        //为空默认为XM
        if (StringUtils.isBlank(mainGoodsDataDto.getJudge())){
            mainGoodsDataDto.setJudge("XM");
        }
        mainGoodsDataVo.setTop(ipMainGoodsDataMapper.getTopData(basUrl,mainGoodsDataDto.getJudge()));
        mainGoodsDataVo.setAdvertiseposition(ipMainGoodsDataMapper.getRightData(basUrl,mainGoodsDataDto.getJudge()));
        mainGoodsDataVo.setRecomend(ipMainGoodsDataMapper.getMiddleData(basUrl,mainGoodsDataDto.getJudge()));
        mainGoodsDataVo.setPromotion(ipMainGoodsDataMapper.getPromotionData(basUrl,mainGoodsDataDto.getJudge()));
        mainGoodsDataVo.setSeconds(ipMainGoodsDataMapper.getSecondsData(mainGoodsDataDto.getJudge()));
        return mainGoodsDataVo;
    }

    @Override
    public void updateMainGoodsData(MainGoodsDataDto mainGoodsDataDto) {

        if (mainGoodsDataDto.getTop() != null){
            if(!mainGoodsDataDto.getTop().isEmpty()&&mainGoodsDataDto.getTop().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTop();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.updateTopData(goodsDataDto);
                }
            }
        }
        if (mainGoodsDataDto.getTopadvertiseposition() != null){
            if(!mainGoodsDataDto.getTopadvertiseposition().isEmpty()&&mainGoodsDataDto.getTopadvertiseposition().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTopadvertiseposition();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.updateRightData(goodsDataDto);
                }
            }
        }
        if (mainGoodsDataDto.getRecommend() != null){
            if(!mainGoodsDataDto.getRecommend().isEmpty()&&mainGoodsDataDto.getRecommend().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getRecommend();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.updateMiddleData(goodsDataDto);
                }
            }
        }
        if (mainGoodsDataDto.getPromotion() != null){
            if(!mainGoodsDataDto.getPromotion().isEmpty()&&mainGoodsDataDto.getPromotion().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getPromotion();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.updatePromotionData(goodsDataDto);
                }
            }
        }
        if (mainGoodsDataDto.getSeconds() != null){
            if(!mainGoodsDataDto.getSeconds().isEmpty()&&mainGoodsDataDto.getSeconds().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getSeconds();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.updateSecondsData(goodsDataDto);
                }
            }
        }
    }

    @Override
    public void deleteMainGoodsDate(MainGoodsDataDto mainGoodsDataDto) {
        if (mainGoodsDataDto.getTop() != null){
            if(!mainGoodsDataDto.getTop().isEmpty()&&mainGoodsDataDto.getTop().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTop();
                for (GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.deleteTopData(goodsDataDto.getId());
                }
            }
        }
        if (mainGoodsDataDto.getTopadvertiseposition() != null){
            if(!mainGoodsDataDto.getTopadvertiseposition().isEmpty()&&mainGoodsDataDto.getTopadvertiseposition().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getTopadvertiseposition();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.deleteRightData(goodsDataDto.getId());
                }
            }
        }
        if (mainGoodsDataDto.getRecommend() != null){
            if(!mainGoodsDataDto.getRecommend().isEmpty()&&mainGoodsDataDto.getRecommend().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getRecommend();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.deleteMiddleData(goodsDataDto.getId());
                }
            }
        }
        if (mainGoodsDataDto.getPromotion() != null){
            if(!mainGoodsDataDto.getPromotion().isEmpty()&&mainGoodsDataDto.getPromotion().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getPromotion();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.deletePromotionData(goodsDataDto.getId());
                }
            }
        }
        if (mainGoodsDataDto.getSeconds() != null){
            if(!mainGoodsDataDto.getSeconds().isEmpty()&&mainGoodsDataDto.getSeconds().size()>0){
                List<GoodsDataDto> goodsDataDtoList = mainGoodsDataDto.getSeconds();
                for(GoodsDataDto goodsDataDto:goodsDataDtoList){
                    ipMainGoodsDataMapper.deleteSecondsData(goodsDataDto.getId());
                }
            }
        }
    }

    @Override
    public String addMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception {
        IpMobileAdvertising mobileAdvertising = new IpMobileAdvertising();
        IpMobileAdvertisingLogs mobileAdvertisingLogs = new IpMobileAdvertisingLogs();
        this.commonBuild(mobileAdvertising,mobileAdvertisingDto);
        this.commonBuild(mobileAdvertisingLogs,mobileAdvertisingDto);
        if (mobileAdvertising.getEffectdate() == null || mobileAdvertising.getFailuredate() == null){
            Integer count = mobileAdvertisingMapper.selectIsSet(mobileAdvertising);
            if (count > 0){
                throw new BusinessException(500,"该广告位存在生效的，设置长期有效失败。");
            }
        }else {
            Integer count = mobileAdvertisingMapper.selectLongTime(mobileAdvertising);
            if (count > 0){
                throw new BusinessException(500,"该广告位存在长期有效");
            }
        }
        String count = mobileAdvertisingMapper.selectConflictSave(mobileAdvertising);
        if ("N".equals(count)){
            throw new BusinessException(500,"广告位设置存在冲突的时间");
        }
        if (mobileAdvertising.getGoodsid() != null){
            String suppliernum = mobileAdvertisingMapper.selectSupplierNum(mobileAdvertising.getGoodsid());
            mobileAdvertising.setSuppliernum(suppliernum);
        }
        mobileAdvertising.setInputdate(new Date());
        mobileAdvertisingMapper.addMobileAdvertising(mobileAdvertising);
        mobileAdvertisingLogs.setInputdate(new Date());
        mobileAdvertisingLogs.setType("新增");
        mobileAdvertisingLogsMapper.addMobileAdvertisingLogs(mobileAdvertisingLogs);
        return "新增广告成功";
    }

    @Override
    public String updateMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception {
        IpMobileAdvertising mobileAdvertising = new IpMobileAdvertising();
        IpMobileAdvertisingLogs mobileAdvertisingLogs = new IpMobileAdvertisingLogs();
        this.commonBuild(mobileAdvertising,mobileAdvertisingDto);
        this.commonBuild(mobileAdvertisingLogs,mobileAdvertisingDto);
        if (mobileAdvertising.getEffectdate() == null || mobileAdvertising.getFailuredate() == null){
            Integer count = mobileAdvertisingMapper.selectIsSet(mobileAdvertising);
            if (count > 0){
                throw new BusinessException(500,"该广告位存在生效的，设置长期有效失败。");
            }
        }else {
            Integer count = mobileAdvertisingMapper.selectLongTime(mobileAdvertising);
            if (count > 0){
                throw new BusinessException(500,"该广告位存在长期有效");
            }
        }
        String count = mobileAdvertisingMapper.selectConflictUpdate(mobileAdvertising);
        if ("N".equals(count)){
            throw new BusinessException(500,"广告位设置存在冲突的时间");
        }
        if (mobileAdvertising.getGoodsid() != null){
            String suppliernum = mobileAdvertisingMapper.selectSupplierNum(mobileAdvertising.getGoodsid());
            mobileAdvertising.setSuppliernum(suppliernum);
        }
        mobileAdvertising.setUpdatedate(new Date());
        mobileAdvertisingMapper.updateMobileAdvertising(mobileAdvertising);
        mobileAdvertisingLogs.setId(null);
        mobileAdvertisingLogs.setType("更新");
        mobileAdvertisingLogs.setInputdate(new Date());
        mobileAdvertisingLogsMapper.addMobileAdvertisingLogs(mobileAdvertisingLogs);
        return "更新广告成功";
    }

    @Override
    public void deleteMobileAdvertising(IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception {
        IpMobileAdvertising mobileAdvertising = new IpMobileAdvertising();
        this.commonBuild(mobileAdvertising,mobileAdvertisingDto);
        mobileAdvertising.setIsdel(true);
        mobileAdvertisingMapper.updateMobileAdvertising(mobileAdvertising);

        IpMobileAdvertising mobileAdvertisings = mobileAdvertisingMapper.selectAdvertisingMapper(mobileAdvertising.getId());
        IpMobileAdvertisingLogs mobileAdvertisingLogs = new IpMobileAdvertisingLogs();
        this.commonBuild(mobileAdvertisingLogs,mobileAdvertisings);
        mobileAdvertisingLogs.setId(null);
        mobileAdvertisingLogs.setType("删除");
        mobileAdvertisingLogs.setInputdate(new Date());
        mobileAdvertisingLogsMapper.addMobileAdvertisingLogs(mobileAdvertisingLogs);
    }

    @Override
    public PageInfo<MobileAdvertisingDto> queryAdvertisingList(IpMobileAdvertisingPageDto pageDto) throws Exception {
        //列表查询时，将已经失效的广告位置设置为失效
        List<IpMobileAdvertisingDto> mobileAdvertisingDtoList = mobileAdvertisingMapper.selectMobileAdvertisingFailureDate();
        if (mobileAdvertisingDtoList != null && mobileAdvertisingDtoList.size() > 0){
            for (IpMobileAdvertisingDto mobileAdvertisingDto : mobileAdvertisingDtoList){
                this.deleteMobileAdvertising(mobileAdvertisingDto);
            }
        }
        PageHelper.startPage(pageDto.getPagenum(),pageDto.getPagesize());
        pageDto.setBasUrl(basUrl);
        List<MobileAdvertisingDto> list = mobileAdvertisingMapper.queryAdvertisingList(pageDto);
        return new PageInfo<>(list);
    }

    @Override
    public MobileAdvertisingDto queryAdvertising(IpMobileAdvertisingPageDto pageDto) throws Exception {
        pageDto.setBasUrl(basUrl);
        return mobileAdvertisingMapper.queryAdvertising(pageDto);
    }

    @Override
    public PageInfo<MobileAdvertisingDto> queryAdvertisingLogsList(IpMobileAdvertisingPageDto pageDto) throws Exception {
        PageHelper.startPage(pageDto.getPagenum(),pageDto.getPagesize());
        pageDto.setBasUrl(basUrl);
        List<MobileAdvertisingDto> list = mobileAdvertisingLogsMapper.queryAdvertisingLogsList(pageDto);
        return new PageInfo<>(list);
    }

    @Override
    public PageInfo<MobileAdvertisingDto> queryAdvertise(IpMobileAdvertisingPageDto pageDto) throws Exception {
        PageHelper.startPage(pageDto.getPagenum(),pageDto.getPagesize());
        pageDto.setBasUrl(basUrl);
        List<MobileAdvertisingDto> list = mobileAdvertisingMapper.queryAdvertise(pageDto);
        return new PageInfo<>(list);
    }

    @Override
    public Map<String, Object> searchRecommend() throws Exception {
        Map<String, Object> map=new HashMap<String, Object>();
        Map<String, Object> hotpurchases=new HashMap<String,Object>();
        List<Map<String, Object>> hotPurchaseIds = ipMainGoodsMapper.getHotPurchaseId(basdb);
        if(hotPurchaseIds!=null && hotPurchaseIds.size()>0){
            for (int i=0;i<hotPurchaseIds.size();i++) {
                String id  =hotPurchaseIds.get(i).get("id")==null?"0":hotPurchaseIds.get(i).get("id")+"";
                List<Map<String, Object>> hotPurchaseInfo = ipMainGoodsMapper.getHotPurchaseInfo(basdb,id,imgurl);
//                  if(hotPurchaseInfo!=null && hotPurchaseInfo.size()>0){
                      if(i==0){
                          hotpurchases.put("first",hotPurchaseInfo);
                      }else if(i==1){
                          hotpurchases.put("second",hotPurchaseInfo);
                      }else if(i==2){
                          hotpurchases.put("third",hotPurchaseInfo);
                      }else if(i==3){
                          hotpurchases.put("fourth",hotPurchaseInfo);
                      }else if(i==4){
                          hotpurchases.put("fifth",hotPurchaseInfo);
                      }
//                  }else {
//                      if(i==0){
//                          hotpurchases.put("first",hotPurchaseInfo);
//                      }else if(i==1){
//                          hotpurchases.put("second",hotPurchaseInfo);
//                      }else if(i==2){
//                          hotpurchases.put("third",hotPurchaseInfo);
//                      }else if(i==3){
//                          hotpurchases.put("fourth",hotPurchaseInfo);
//                      }else if(i==4){
//                          hotpurchases.put("fifth",hotPurchaseInfo);
//                      }
//                  }
            }

        }else{
            ArrayList<Map<String, Object>> maps = new ArrayList<>();
            hotpurchases.put("first",maps);
            hotpurchases.put("second",maps);
            hotpurchases.put("third",maps);
            hotpurchases.put("fourth",maps);
            hotpurchases.put("fifth",maps);
        }
        map.put("hotpurchase",hotpurchases);
        List<Map<String, Object>> newArrivalsInfo = ipMainGoodsMapper.getNewArrivalsInfo(basdb,imgurl);
        map.put("newarrivals",newArrivalsInfo);
        return map;
    }

}
