package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.service.IpGoodFootService;
import com.ekingwin.bas.cloud.service.IpGoodsDraftService;
import com.ekingwin.bas.cloud.service.IpGoodsService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-27 15:14
 **/
@RestController
@RequestMapping(value = "/goods/")
@Api(tags = "商品管理", description = "商品管理", value = "商品管理")
public class GoodsController {


    @Autowired
    private IpGoodsService ipGoodsService;


    @Autowired
    private IpGoodsDraftService ipGoodsDraftService;

    @Autowired
    private IpGoodFootService ipGoodFootService;



    @ApiOperation(value = "商品新增与修改", notes = "商品新增与修改")
    @PostMapping(value = "/saveOrUpdateGoods")
    public Result saveOrUpdateGoods(@RequestBody GoodsAddDto goodsAddDto) throws Exception{
        Long busskey=ipGoodsService.saveGoods(goodsAddDto);
        return  Result.ok(busskey);
    }
    @ApiOperation(value = "获取商品详情", notes = "获取商品详情",response = GoodsDeatilVo.class)
    @PostMapping(value = "/getGoodsData")
    public Result getGoodsData(@RequestBody GoodsGetDetailDto goodsGetDetailDto) throws  Exception{
        GoodsDeatilVo goodsDeatilVo=ipGoodsService.getGoodsDetail(goodsGetDetailDto);
        //记录足迹
        String checkType = goodsGetDetailDto.getCheckType();
        if ("DETAIL".equals(checkType)){
            ipGoodFootService.saveGoodsFoot(goodsDeatilVo,goodsGetDetailDto);
        }

        return  Result.ok(goodsDeatilVo);
    }

    @ApiOperation(value = "获取商品描述", notes = "获取商品描述",response = IpGoodsDetailVo.class)
    @PostMapping(value = "/getGoodsDetail")
    public Result getGoodsDetail(@RequestBody GoodsGetDetailDto goodsGetDetailDto) throws  Exception{
        IpGoodsDetailVo goodsDeatilVo=ipGoodsService.getGoodsDetails(goodsGetDetailDto);
        return  Result.ok(goodsDeatilVo);
    }

    @ApiOperation(value = "获取商品运费", notes = "获取商品运费")
    @PostMapping(value = "/getGoodsFreight")
    public Result getGoodsFreight(@RequestBody IpGoodsFreightDto ipGoodsFreightDto) throws  Exception{
        float price=ipGoodsService.getGoodsFreight(ipGoodsFreightDto);
        return  Result.ok(price);
    }

    @ApiOperation(value = "修改厂商和分类数据", notes = "修改厂商和分类数据")
    @PostMapping(value = "/updateGoodsCategory")
    public Result updateGoodsCategory(@RequestBody GoodsCategoryDto goodsCategoryDto) throws Exception{
        ipGoodsService.updateGoodsCategory(goodsCategoryDto);
        return   Result.ok();
    }

    @ApiOperation(value = "商品上下架、作废", notes = "商品上下架、作废")
    @PostMapping(value = "/upOrLowerRacks")
    public Result upOrLowerRacks(@RequestBody BoGoodUpDto boGoodUpDto) throws Exception{
        ipGoodsService.approvalGoods(boGoodUpDto);
        return   Result.ok();
    }

    @ApiOperation(value = "同步sap数据", notes = "同步sap数据")
    @PostMapping(value = "/initGoodsSapId/{goodsid}")
    public Result initGoodsSapId(@PathVariable(value = "goodsid") String goodsId) throws Exception{
        ipGoodsService.initGoodsSapId("03",goodsId,null);
        return   Result.ok();
    }


    @ApiOperation(value = "流程审批结束", notes = "流程审批结束")
    @PostMapping(value = "/initGoodsProcess")
    public Result initGoodsProcess(@RequestBody IpGoodsProcessDto ipGoodsProcessDto) throws Exception{
        ipGoodsService.initGoodsProcess(ipGoodsProcessDto);
        return   Result.ok();
    }

    @ApiOperation(value = "商品操作记录", notes = "商品操作记录")
    @PostMapping(value = "/getGoodsLogs")
    public Result getGoodsLogs(@RequestBody GoodsGetDetailDto goodsGetDetailDto) throws Exception{
        PageInfo goodsLogs=ipGoodsService.getGoodsLogs(goodsGetDetailDto);
        return   Result.ok(goodsLogs);
    }


    @ApiOperation(value = "根据客户类型获取商品价格", notes = "根据客户类型获取商品价格")
    @PostMapping(value = "/getGoodsPrice")
    public Result getGoodsPrice(@RequestBody IpGoodPriceDto ipGoodPriceDto) throws  Exception{
        IpGoodPriceVo ipGoodPriceVo=ipGoodsService.getGoodsPrice(ipGoodPriceDto);
        return  Result.ok(ipGoodPriceVo);
    }

    @ApiOperation(value = "导出Excel", notes = "导出Excel")
    @GetMapping(value = "/exportExcel")
    public void exportExcel(String goodsId,String goodsName, HttpServletResponse response) throws  Exception{

        ipGoodsService.exportExcel(goodsId,response,goodsName);
    }

    @ApiOperation(value = "商品导入", notes = "商品导入")
    @PostMapping(value = "/importGoods")
    public Result importGoods(@RequestParam(value="file",required=false) MultipartFile myFile,
                            @RequestParam(value="userid",required=false) String userid,
                              @RequestParam(value = "categoryType") String categoryType) throws  Exception{
        GoodsImportVo goodsImportVo =null;
        /*if(StringUtils.isNotEmpty(categoryType) && "XM".equals(categoryType)){*/
            goodsImportVo =ipGoodsService.importGoods(myFile,userid,categoryType);
       /* }*/


        return Result.ok(goodsImportVo);
    }


    @ApiOperation(value = "商品库管理", notes = "商品库管理",response = GoodsMessageVo.class)
    @PostMapping(value = "/getGoodsMessage")
    public Result getGoodsMessage(@RequestBody GoodsMessageCategoryDto categoryDto) throws Exception{
        GoodsMessageVo goodsMessage = ipGoodsService.getGoodsMessage(categoryDto);
        return Result.ok(goodsMessage);
    }
    @ApiOperation(value = "商品复制", notes = "商品复制")
    @PostMapping(value = "/copyGoods")
    public Result copyGoods(@RequestBody CopyGoodsDto copyGoodsDto)
            throws Exception{
        ipGoodsService.copyGoods(copyGoodsDto);
        return Result.ok();
    }

    @ApiOperation(value = "根据流程实例号获取商品所属商品库", notes = "根据流程实例号获取商品所属商品库")
    @GetMapping(value = "/getGoodsCategory/{instid}")
    public Result getGoodsCategory(@PathVariable(value = "instid") String instid)
            throws Exception{
        String goodsCategory = ipGoodsDraftService.getGoodsCategory(instid);

        return Result.ok(goodsCategory);
    }

    @ApiOperation(value = "获取商品的规格型号", notes = "获取商品的规格型号",response =GoodsSpecificationVo.class )
    @PostMapping(value = "/getGoodsSpecification")
    public Result getGoodsSpecification(@RequestBody GoodsSpecificationDto goodsSpecificationDto) throws Exception{
        GoodsSpecificationVo goodsSpecification = ipGoodsService.getGoodsSpecification(goodsSpecificationDto);
        return  Result.ok(goodsSpecification);
    }

}
