package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpGoodsSearchDto;
import com.ekingwin.bas.cloud.dto.IpLicensornameDto;
import com.ekingwin.bas.cloud.service.IpGoodsSolrService;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.ekingwin.bas.cloud.vo.IpLicensornameVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-26 10:59
 **/
@RestController
@RequestMapping(value = "/goodsSolr/")
@Api(tags = "solr接口", description = "solr接口", value = "solr接口")
public class GoodsSolrController {


    @Autowired
    private IpGoodsSolrService ipGoodsSolrService;

    @ApiOperation(value = "查询商品", notes = "查询商品")
    @PostMapping(value = "/getsSolrData")
    public Result getsSolrData(@RequestBody IpGoodsSearchDto ipGoodsSearchDto) throws  Exception{
        String jsonObject =ipGoodsSolrService.getsSolrData(ipGoodsSearchDto);
        return  Result.ok(jsonObject);
    }

    @ApiOperation(value = "查询商品授权区域", notes = "查询商品授权区域")
    @PostMapping(value = "/getLicensorname")
    public Result getLicensorname(@RequestBody IpLicensornameDto ipLicensornameDto){
        List<IpLicensornameVo> licensornameVoList=ipGoodsSolrService.getLicensorname(ipLicensornameDto);
        return  Result.ok(licensornameVoList);
    }
}
