package com.ekingwin.bas.cloud.dao;


import com.ekingwin.bas.cloud.vo.IpCategorySuppliersVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface IpCategoryMapper {

    /**
     * 获取供应商信息
     * @param baseUrl
     * @param categoryId
     * @return
     */
    List<IpCategorySuppliersVo> getSupplier(@Param(value = "baseUrl") String baseUrl ,@Param(value = "categoryId") String categoryId);


    /**
     * 获取分类信息
     * @param categoryId
     * @return
     */
    IpCategorySuppliersVo getCategory(@Param(value = "categoryId") String categoryId);


    /**
     * 修改分类是否显示
     * @param baseUrl
     * @param categoryId
     * @param idDisplay
     * @return
     */
    int updateCategory(@Param(value = "baseUrl")String baseUrl ,
                       @Param(value = "categoryId") String categoryId,
                       @Param(value = "idDisplay") String idDisplay );


    /**
     * 获取分类
     * @param map
     * @return
     */
   Map<String,Object>getGoodCateCode(Map<String,Object> map);



    Map<String,Object>getGoodCateCodeByGr(Map<String,Object> map);

}
