package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpGoodsCategoryDto;
import com.ekingwin.bas.cloud.dto.SaveGoodsCategoryDto;
import com.ekingwin.bas.cloud.vo.*;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-18 11:42
 **/
@Repository
public interface IpGoodsCategoryMapper {

    List<IpGoodsCategoryVo> getThirdClassify(IpGoodsCategoryDto ipGoodsCategoryDto);

    IpThirdCategoryInfoVo getGoodsCategoryInfo( @Param(value="categoryId")String categoryId);

    List<IpGoodsCategoryDetailVo> getThirdClassifyBy(IpGoodsCategoryDto ipGoodsCategoryDto);

    int insertGoodsCategory(SaveGoodsCategoryDto saveGoodsCategoryDto);

    int batchInsertCategorySup(@Param(value = "areaVos") List<IpGoodSupplierAreaVo> areaVos);

    int batchInsertCategoryPrice(@Param(value = "salesPrice") List<IpCategoryGoodsPriceVo> salesPrice);

    int updateGoodsCategory(SaveGoodsCategoryDto saveGoodsCategoryDto);

    int deleteCategorySup(@Param(value = "categoryId") String categoryId);

    int deleteCategoryPrice(@Param(value = "categoryId") String categoryId);

    int getGoodsCountByCategoryCode(@Param(value = "categoryId")String categoryId);

    int deleteGoodsCategory(@Param(value = "categoryId")String categoryId);

    List<IpGoodsCategoryDetailVo> getNextLevelInfo(@Param(value="categoryId")String categoryId);

    List<IpGoodsCategoryDetailVo> getGoodsCategoryInfoByLevel(IpGoodsCategoryDto ipGoodsCategoryDto);

    List<IpGoodsCategoryDetailVo> getGoodsCategoryInfoByLevel1(IpGoodsCategoryDto ipGoodsCategoryDto);

    List<IpGoodsCategoryDetailVo> getGoodsCategoryInfoByLevel2(IpGoodsCategoryDto ipGoodsCategoryDto);

    int getCategoryCodeCount(@Param(value = "code") String code);


    /**
     * 获取区域信息
     * @param goodsCategoryId
     * @return
     */
    List<IpGoodSupplierAreaVo> getAreaInfo(String goodsCategoryId);


    String getCompanyParent(String salesarea);

    List<IpGoodSupplierAreaVo> getAreaInfoOrSupplierId(@Param(value = "id") String id,
                                                       @Param(value = "supplierid") String supplierid);


    List<GoodsCategoryTreeVo> getCompanyList(String salesarea);


    /**
     * 获取子级
     * @param salesarea
     * @return
     */
    String getCompanyChild(@Param(value = "salesarea") String salesarea);

    /**
     * 获取商品分类权限
     * @param companyid
     * @return
     */
    List<Map<String,Object>> getGoodsCategAuthority(@Param(value = "basUrl") String basUrl,@Param(value = "companyid") String  companyid);
    /**
     * 获取商品分类
     * @param companyid
     * @return
     */
    List<Map<String,Object>> getAllGoodsCategInfo(@Param(value = "basUrl") String basUrl,@Param(value = "id") String  id);
}
