package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.GoodsEvaluationAgainDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationPageDto;
import com.ekingwin.bas.cloud.entity.IpGoodsEvaluation;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public interface IpGoodsEvaluationMapper {

    List<IpGoodsEvaluation> selectGoodsEvaluation(Long goodsId);
    List<IpGoodsEvaluation> selectMyEvaluation(@Param(value = "goodsId") Long goodsId,@Param(value = "evaluationId") String evaluationId);

    IpGoodsEvaluation selectGoodsComprehensiveScore(Long goodsId);

    void saveGoodsEvaluation(IpGoodsEvaluation evaluation);

    void updateOrderAllGoods(Map map);


    /**
     * 查询当前用户的权限问题
     * @param
     * @return
     */
    Integer queryJurisdiction(String evaluationId);

    /**
     * 查询回复信息
     * @param id
     * @return
     */
    List<GoodsEvaluationAgainDto> selectreply(Integer id);

    /**
     * 回复评价信息
     * @param evaluationAgain
     */
    void addReplyGoodsEvaluation(GoodsEvaluationAgainDto evaluationAgain);

    /**
     * 可以所有评论都有权限删除
     * @param evaluationAgain
     */
    void deleteEvaluation(GoodsEvaluationAgainDto evaluationAgain);

    /**
     * 所有评价对应的回复信息都有权限删除
     * @param evaluationAgain
     */
    void deleteReply(GoodsEvaluationAgainDto evaluationAgain);

    /**
     * 可以删除自己评论
     * @param evaluationAgain
     */
    void deleteMyEvaluation(GoodsEvaluationAgainDto evaluationAgain);
}
