package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.vo.IpGoodsManageSuppliersVo;
import com.ekingwin.bas.cloud.vo.IpGoodsManageVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSapPriceVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpGoodsManageMapper {



    List<IpGoodsManageVo> getGoodsManage(String goodsId);


    /**
     *  根据分类获取供应商数据
     * @param categoryId
     * @return
     */
    List<IpGoodsManageSuppliersVo> getGoodsManageSupplier(String categoryId);


    /**
     * 获取根节点
     * @param rootId
     * @return
     */
    String getChildCode(String rootId);

    /**
     *  获取所有的项目编号
     * @param treeId
     * @return
     */
    List<String> getProjectCode(String treeId);


    /**
     *  sap价格
     * @param goodsId
     * @return
     */
    List<IpGoodsSapPriceVo> getGoodsPrice(String goodsId);

}
