package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpGoodPriceDto;
import com.ekingwin.bas.cloud.dto.IpGoodsStockDto;
import com.ekingwin.bas.cloud.entity.IpGoodsPrice;
import com.ekingwin.bas.cloud.vo.IpGoodsExcelVo;
import com.ekingwin.bas.cloud.vo.LoginUserVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @program: rcworkspace
 * @description:商品价格
 * @author: zhangjie
 * @create: 2019-06-27 16:07
 **/
@Repository
public interface IpGoodsPriceMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpGoodsPrice record);

    int insertSelective(IpGoodsPrice record);

    IpGoodsPrice selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpGoodsPrice record);

    int updateByPrimaryKey(IpGoodsPrice record);

    /**
     * 根据商品ID删除商品价格
     *
     * @param goodsId the goods id
     * @return int
     */
    int deleteByGoodsid(Long goodsId);

    /**
     * 标记为删除
     * @param goodsId
     * @return
     */
    int updateByGoodsid(Long goodsId);


    /**
     * 根据商品id获取商品价格
     * @param goodsId
     * @return
     */
    List<IpGoodsPrice> getDetailByGoodsid(Long goodsId);


    /**
     * 2获取外部用户的价格
     * @param ipGoodPriceDto
     * @return
     */
    IpGoodsPrice getOutGoodsPrice(IpGoodPriceDto ipGoodPriceDto);

    /**
    * 内部员工获取商品价格
    * @Param:  * @param goodsId
    * @return: com.ekingwin.bas.cloud.entity.IpGoodsPrice
    * @Author: zhangjie
    * @Date: 2019/10/28 20:53
    */
    IpGoodsPrice getOutGoodsPriceNbyg(Long goodsId);

    /**
     *  获取商品信息
     * @param goodsId
     * @return
     */
    List<IpGoodsPrice> getOutGoodsPriceList(Long goodsId);

    /**
     * 获取内部用户的价格
     * @param orglist
     * @param goodsId
     * @return
     */
    IpGoodsPrice getInsideGoodsPrice(@Param(value = "orglist") String orglist,
                                     @Param(value = "goodsId") Long goodsId);

    /**
     * 根据当前登录用户所在公司获取价格
     * @param companyId
     * @param goodsId
     * @return
     */
    IpGoodsPrice getInsideGoodsPriceByCompanyId(@Param(value = "companyId") String companyId,
                                                @Param(value = "goodsId") Long goodsId,
                                                @Param(value = "orglist") String orglist);


    /**
     * 获取当前登录人所有岗位
     * @param bassurl
     * @param userId
     * @return
     */
    List<String> getEmployUser(@Param(value = "baseurl") String bassurl,
                               @Param(value = "userId") String userId);

    /**
     * 获取组织机构
     * @param bassurl
     * @param orgid
     * @return
     */
    String getTree(@Param(value = "baseurl") String bassurl,
                         @Param(value = "orgid") String orgid);



    /**
     * 获取组织机构
     * @param bassurl
     * @param orgid
     * @return
     */
    String getParentTree(@Param(value = "baseurl") String bassurl,
                         @Param(value = "orgid") String orgid);


    /**
     * 根据商品ID获取信息
     *
     * @param goodsId the goods id
     * @return goods price by goods id
     */
    List<IpGoodsExcelVo> getGoodsPriceByGoodsId(@Param(value = "goodsId") String goodsId);


    /**
     * Gets user detail.
     *
     * @param userId the user id
     * @return the user detail
     */
    /*
     * 获取用户的信息
     * @Param:  * @param userId
     * @return: java.util.List<com.ekingwin.bas.cloud.vo.LoginUserVo>
     * @Author: zhangjie
     * @Date: 2019/10/28 20:45
     */
    List<LoginUserVo> getUserDetail(String userId);

    /**
     * 扣减库存
     *
     * @param goodsStockDto the goods stock dto
     * @return int
     */
    int updateGoodsStock(IpGoodsStockDto goodsStockDto);

    /**
     * 根据商品ID和价格ID获取商品是否存在
     *
     * @param id      the id
     * @param goodsId the goods id
     * @return detail by goodsid count
     */
    int getDetailByGoodsidCount(@Param(value = "id") Long id,@Param(value = "goodsId") Long goodsId);


    /**
     * Gets category salare.
     *
     * @param categoryId the category id
     * @param supplierid the supplierid
     * @return category salare
     */
    List<String> getCategorySalare(@Param(value = "categoryId") String categoryId,@Param(value = "supplierid") String supplierid);


    /**
     * 获取供货品类类型
     *
     * @param salesarea the salesarea
     * @return category tree type
     */
    String getCategoryTreeType(@Param(value = "salesarea") String salesarea);


    /**
     * 获取项目公司的个数
     *
     * @param salesarea the salesarea
     * @return category xm company
     */
    int getCategoryXmCompany(@Param(value = "salesarea") String salesarea);

    /**
     * 获取城市公司的个数
     *
     * @param salesarea the salesarea
     * @return category city company
     */
    int getCategoryCityCompany(@Param(value = "salesarea") String salesarea);


    /**
     * 获取项目人员
     *
     * @param salesarea the salesarea
     * @return user persion xm
     */
    String getUserPersionXm(@Param(value = "salesarea") String salesarea);

    /**
     * 获取城市人员
     *
     * @param salesarea the salesarea
     * @return user persion city
     */
    String getUserPersionCity(@Param(value = "salesarea") String salesarea);


    /**
     * 获取区域人员
     *
     * @param salesarea the salesarea
     * @return user persion area
     */
    String getUserPersionArea(@Param(value = "salesarea") String salesarea);


    /**
     * 获取父级
     *
     * @param salesarea the salesarea
     * @return company parent
     */
    String getCompanyParent(@Param(value = "salesarea") String salesarea);



}