package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpGoodsSearchDto;
import com.ekingwin.bas.cloud.dto.IpLicensornameDto;
import com.ekingwin.bas.cloud.vo.IpLicensornameVo;
import com.ekingwin.bas.cloud.vo.LoginUserVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpGoodsSolrMapper {

    /**
     * 获取当前登录人所有岗位
     * @param bassurl
     * @param userId
     * @return
     */
    List<String> getEmployUser(@Param(value = "baseurl") String bassurl,
                               @Param(value = "userId") String userId);

    /**
     * 获取组织机构
     * @param bassurl
     * @param orgid
     * @return
     */
    String getTree(@Param(value = "baseurl") String bassurl,
                   @Param(value = "orgid") String orgid);



    /**
     * 获取组织机构
     * @param bassurl
     * @param orgid
     * @return
     */
    String getParentTree(@Param(value = "baseurl") String bassurl,
                         @Param(value = "orgid") String orgid);


    /**
     * 查询所有的授权商
     * @param ipLicensornameDto
     * @return
     */
    List<IpLicensornameVo> getLicensorname(IpLicensornameDto ipLicensornameDto);


    /**
     * 获取三级分类
     * @param ipGoodsSearchDto
     * @return
     */
    List<String> getCategoryId(IpGoodsSearchDto ipGoodsSearchDto);

}
