package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpGoodsFreightDto;
import com.ekingwin.bas.cloud.entity.IpGoodsSuppliers;
import com.ekingwin.bas.cloud.entity.IpGoodsSuppliersProcess;
import com.ekingwin.bas.cloud.vo.IpGoodsSupplierFreightVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSuppliersVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:商品供应商
 * @author: zhangjie
 * @create: 2019-06-27 15:28
 **/
@Repository
public interface IpGoodsSuppliersProcessMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpGoodsSuppliersProcess record);

    int insertSelective(IpGoodsSuppliersProcess record);

    IpGoodsSuppliersProcess selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpGoodsSuppliersProcess record);

    int updateByPrimaryKey(IpGoodsSuppliersProcess record);

    /**
     * 删除供应商
     * @param goodsId
     * @return
     */
    int deleteByGoodsId(Long goodsId);

    /**
     * 获取供应商
     * @param goodsId
     * @return
     */
    List<IpGoodsSuppliersVo> selectByGoodsId(Long goodsId);

}