package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.GoodsDataDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author 许世文
 * @Date 2019/8/6 15:44
 * @Version 1.0
 **/
@Repository
public interface IpMainGoodsDataMapper {

    int getTopMaxSort();

    int getRightMaxSort();

    int getMiddleMaxSort();

    int getPromotionSort();

    int getSecondsSort();

    int insertTopData(@Param(value = "topData") List<GoodsDataDto> topData);

    int insertRightData(@Param(value = "rightData") List<GoodsDataDto> rightData);

    int insertMiddleData(@Param(value = "middleData") List<GoodsDataDto> middleData);

    int insertPromotionData(@Param(value = "middleData") List<GoodsDataDto> middleData);

    int insertSecondsData(@Param(value = "middleData") List<GoodsDataDto> middleData);

    int updateTopData(GoodsDataDto topData);

    int updateRightData(GoodsDataDto rightData);

    int updateMiddleData(GoodsDataDto middleData);

    int updatePromotionData(GoodsDataDto middleData);

    int updateSecondsData(GoodsDataDto middleData);

    List<GoodsDataDto> getTopData(@Param(value = "basUrl") String basUrl,@Param(value = "judge") String judge);

    List<GoodsDataDto> getRightData(@Param(value = "basUrl") String basUrl,@Param(value = "judge") String judge);

    List<GoodsDataDto> getMiddleData(@Param(value = "basUrl") String basUrl,@Param(value = "judge") String judge);

    List<GoodsDataDto> getPromotionData(@Param(value = "basUrl") String basUrl,@Param(value = "judge") String judge);

    List<GoodsDataDto> getSecondsData(@Param(value = "judge") String judge);

    int deleteTopData(@Param(value = "id") int id);

    int deleteRightData(@Param(value = "id") int id);

    int deleteMiddleData(@Param(value = "id") int id);

    int deletePromotionData(@Param(value = "id") int id);

    int deleteSecondsData(@Param(value = "id") int id);

}
