package com.ekingwin.bas.cloud.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @ClassName: IpMobileAdvertisingDto
 * @Author: liujunfeng
 * @Date: 2019/10/29 20:54
 * @description:
 */
@Data
@ApiModel("APP首页图片查询")
public class IpMobileAdvertisingPageDto extends BasePageDto{

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "序号")
    private String pages;

    @ApiModelProperty(value = "GR.个人，XM.项目")
    private String judge;

    @ApiModelProperty(value = "图片路径前缀",hidden = true)
    private String basUrl;

    @ApiModelProperty(value = "操作类型")
    private String type;

    @ApiModelProperty(value = "位置")
    private String sort;

    @ApiModelProperty(value = "生效时间开始")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date effectdatemin;

    @ApiModelProperty(value = "生效时间结束")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date effectdatemax;

    @ApiModelProperty(value = "失效时间开始")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date failuredatemin;

    @ApiModelProperty(value = "失效时间结束")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date failuredatemax;

    @ApiModelProperty(value = "录入人")
    private String inputperson;

}
