package com.ekingwin.bas.cloud.dto;


import com.ekingwin.bas.cloud.vo.IpCategoryGoodsPriceVo;
import com.ekingwin.bas.cloud.vo.IpGoodSupplierAreaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("新增分类信息参数")
public class SaveGoodsCategoryDto {

    @ApiModelProperty(value = "分类id")
    private String id;

    @ApiModelProperty(value = "厂商名称")
    private String suppliername;

    @ApiModelProperty(value = "排序")
    private String sort;

    @ApiModelProperty(value = "分类编码")
    private String code;

    @ApiModelProperty(value = "分类名称")
    private String name;

    @ApiModelProperty(value = "供货方式名称")
    private String supplymodename;

    @ApiModelProperty(value = "供货方式编码")
    private String supplymodecode;

    @ApiModelProperty(value = "厂商id")
    private Integer supplierid;

    @ApiModelProperty(value = "父id")
    private Integer pid;

    @ApiModelProperty(value = "分类类型")
    private String type;

    @ApiModelProperty(value = "分类所属首页 XM 项目类 GR 个人")
    private String categoryType;

    @ApiModelProperty(value = "图片id")
    private Integer logoid;

    @ApiModelProperty(value = "图片地址")
    private String logoUrl;

    @ApiModelProperty(value = "用户id")
    private String userid;

    @ApiModelProperty(value = "授权商集合")
    private List<IpGoodSupplierAreaVo> area;

    @ApiModelProperty(value = "销售价格集合")
    private List<IpCategoryGoodsPriceVo> salesPrice;

}
