package com.ekingwin.bas.cloud.goodsMge.web;

import com.ekingwin.bas.cloud.goodsMge.dto.DetailGradeDto;
import com.ekingwin.bas.cloud.goodsMge.dto.GoodsMgeDto;
import com.ekingwin.bas.cloud.goodsMge.service.GoodsDetailService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName GoodsDetailController.java
 * @Description TODO
 * @createTime 2020/3/23 9:11
 */
@RestController
@RequestMapping(value = "/goodsmanage/")
@Api(tags = "商品信息", description = "商品信息", value = "商品信息")
public class GoodsDetailController {
    @Autowired
    private GoodsDetailService goodsDetailService;

    @ApiOperation(value = "商品详情")
    @GetMapping(value = "/getGoodsDetail")
    public Result getGoodsDetail(@RequestParam String id, String companyid) throws Exception{
        return goodsDetailService.getGoodsDetail(id,companyid);
    }

    @ApiOperation(value = "商品详情评价列表")
    @GetMapping(value = "/getGoodsDetailGrade")
    public Result getGoodsDetailGrade(@RequestParam String id,int pagenum,int pagesize) throws Exception{
        DetailGradeDto detailGradeDto=goodsDetailService.getGoodsDetailGrade(id,pagenum,pagesize);
        return Result.ok(detailGradeDto);
    }
}
