package com.ekingwin.bas.cloud.handler;

import com.ekingwin.bas.cloud.util.Result;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @program: eccpWorkflow
 * @description:
 * @author: zhangjie
 * @create: 2019-04-30 16:19
 **/
@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {

    @ExceptionHandler(Exception.class)
    public Result runtimeExceptionHandler(Exception ex) {
        ex.printStackTrace();
        return Result.error();
    }

    @ExceptionHandler({BusinessException.class})
    public Result businessExceptionHandler(BusinessException ex) {

        return Result.error(ex.getMessage());
    }
    @ExceptionHandler(MethodArgumentNotValidException.class)
    public  Result validationBodyException(MethodArgumentNotValidException ex){
        BindingResult result = ex.getBindingResult();
        String message="";
        if (result.hasErrors()) {
            List<ObjectError> errors = result.getAllErrors();
            StringBuilder builder = new StringBuilder();

            errors.forEach(p ->{
                FieldError fieldError = (FieldError) p;
                builder.append(fieldError.getDefaultMessage()+";");
            });
            message=builder.toString();

        }
        return Result.error(message);
    }
}
