package com.ekingwin.bas.cloud.protal.dao;

import com.ekingwin.bas.cloud.protal.dto.*;
import com.ekingwin.bas.cloud.protal.vo.*;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface CommodityManagementMapper {
    /**
     * 销售量排行榜
     * @param salesListVo
     * @return
     */
    List<SalesListDto> SalesList(SalesListVo salesListVo);



    /**
     * 销售量排行榜首页显示
     * @param salesListDto
     * @return
     */
    void AddTheHomepage(SalesListDto salesListDto);



    /**
     * 销售量排行榜商品分类
     * @param goodsClassifyVo
     * @return
     */
    List<GoodsClassifyDto> GoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 开票信息和收货地址列表接口
     * @param invoiceShipAddressListVo
     * @return
     */
    List<InvoiceShipAddressListDto>  InvoiceShipAddressList(InvoiceShipAddressListVo invoiceShipAddressListVo);



    /**
     * 查询出对应的开票信息和收货地址
     * @param
     * @return
     */

    List<InvoiceShipAddressDto> InvoiceShipAddress(InvoiceShipAddressListVo invoiceShipAddressListVo);

    /**
     * 开票信息和收货地址列表接口新增中的子接口查询公司名
     * @param invoiceShipAddressListVo
     * @return
     */
    List<InvoiceShipAddressAddCompanyDto> InvoiceShipAddressAddCompany(InvoiceShipAddressListVo invoiceShipAddressListVo);


    /**
     * 判断是否有重复的Companycode
     * @param shipAddressAddVo
     * @return
     */
    int queryCompanycode(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 添加开票信息和收货地址基本信息
     * @param shipAddressAddVo
     */
    void insertintoInvoice(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 添加开票信息和收货地址的地址
     * @param invoiceShipAddressAddsVo
     */
    void insertintoAddress(InvoiceShipAddressAddsVo invoiceShipAddressAddsVo);

    /**
     * 更新开票信息
     * @param shipAddressAddVo
     */
    void invoiceShipAddressUpdate(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 删除收货地址
     * @param invoiceShipAddressAddsVo
     */
    void invoiceShipAddressdelete(InvoiceShipAddressAddsVo invoiceShipAddressAddsVo);

    /**
     * 删除开票信息
     * @param shipAddressAddVo
     */
    void invoiceShipAddressDelete(InvoiceShipAddressAddVo shipAddressAddVo);

    /**
     * 广告位列表查询接口
     * @param advertiseListVo
     * @return
     */
    List<AdvertiseListDto> AdvertiseList(AdvertiseListVo advertiseListVo);



    /**
     * 广告位列表新增子接口广告位编号查询
     * @return
     */
    List<AdvertiseListDto> AdvertiseAddCode();


    /**
     * 广告位列表新增
     * @param advertiseAddVo
     */
    void AdvertiseAdd(AdvertiseAddVo advertiseAddVo);

    /**
     * 广告位列表编辑
     * @param advertiseAddVo
     */
    void AdvertiseUpdate(AdvertiseAddVo advertiseAddVo);

    /**
     * 广告位列表删除
     * @param advertiseAddVo
     */
    void AdvertiseDelete(AdvertiseAddVo advertiseAddVo);

    /**
     * 查询一级商品库商品分类信息
     * @param goodsClassifyVo
     * @return
     */
    List<GoodsFirstClassifyDto> queryFirstGoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 查询二级商品库商品分类信息
     * @param goodsClassifyVo
     * @return
     */
    List<GoodsSecondClassifyDto> querySecondGoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 查询三级商品库商品分类信息
     * @return
     */
    List<GoodsThirdClassifyDto> queryThirdGoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 查询四级商品库商品分类信息
     * @param goodsClassifyVo
     * @return
     */
    List<GoodsFourthClassifyDto> queryFourthGoodsClassify(GoodsClassifyVo goodsClassifyVo);

    /**
     * 通威商品库查询
     * @param goodsBrandListVo
     * @return
     */
    List<GoodsBrandListDto> GoodsBrandList(GoodsBrandListVo goodsBrandListVo);

    /**
     * 商品库新增中基本信息子接口的商品名称查询
     * @param materielImportVo
     * @return
     */
    List<MaterielImportDto> MaterielImport(MaterielImportVo materielImportVo);

    /**
     * 商品库新增中基本信息子接口的供应商名称查询
     * @param supplierMaterielVo
     * @return
     */
    List<SupplierMaterielDto> querySupplierMateriel(SupplierMaterielVo supplierMaterielVo);

    /**
     * 销售区域一级查询
     * @param goodsClassifyVo
     * @return
     */
    List<SalesareaFirstNameDto> queryFirstSalesareaName(GoodsClassifyVo goodsClassifyVo);

    /**
     * 销售区域二级查询
     * @param
     * @return
     */

    List<SalesareaSecondNameDto> querySecondSalesareaName(GoodsClassifyVo goodsClassifyVo);

    /**
     * 销售区域三级查询
     * @param
     * @return
     */
    List<SalesareaThirdNameDto> queryThirdSalesareaName(GoodsClassifyVo goodsClassifyVo);

    /**
     * 销售区域四级查询
     * @param
     * @return
     */
    List<SalesareaFourthNameDto> queryFourthSalesareaName(GoodsClassifyVo goodsClassifyVo);

    /**
     * 销售区域五级查询
     * @param
     * @return
     */
    List<SalesareaFiveNameDto> queryFiveSalesareaName(GoodsClassifyVo goodsClassifyVo);



    /**
     * 更改状态
     * @param goodsBrandSoldOutIdVo
     */
    void GoodsBrandSoldOut(GoodsBrandSoldOutIdVo goodsBrandSoldOutIdVo);


    /**
     * 查询此商品状态是否为合格，或者为试用状态
     * @param goodsBrandOnTheAuditVo
     * @return
     */
    String GoodsBrandOnTheAudit(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo);

    /**
     * 更新商品上架
     * @param goodsnum
     */

    void UpdategoodsUpOrDownProcessRest_PS(String goodsnum);

    /**
     * 更新上下架表状态
     * @param processid
     */
    void UpdategoodsUpOrDownProcessRest(@Param("processid") String processid,@Param("time") String time,@Param("acrossdatabase") String acrossdatabase);

    /**
     * 终止操作上架，不同意上架
     * @param processid
     * @param time
     * @param acrossdatabase
     */
    void EndgoodsUpOrDownProcessRest(@Param("processid") String processid,@Param("time") String time,@Param("acrossdatabase") String acrossdatabase);
    /**
     * 查询是否是在审核的商品
     * @param goodsBrandOnTheAuditVo
     * @return
     */
    List<SupplierPageMessageDto> queryGoodsUpordown(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo);


    /**
     * 新增商品上下架表数据
     * @param goodsBrandOnTheAuditVo
     */
    void insertGoodsUpOrDown(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo);

    /**
     * 查询商品库信息
     * @param goodsBrandOnTheAuditVo
     * @return
     */
    GoodsBrandOnTheAuditDto queryGoodsMessage(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo);

    /**
     * 新增
     * @param goodsBrandAddVo
     */
    void GoodsBrandAdd(GoodsBrandAddVo goodsBrandAddVo);

    /**
     * 查询是否重复添加
     * @param goodsnum
     * @return
     */
    Integer querygoodsnum(String goodsnum);

    /**
     * 编辑商品库
     * @param goodsBrandAddVo
     */
    void GoodsBrandUpdate(GoodsBrandAddVo goodsBrandAddVo);

    /**
     * 逻辑查询上下架次数
     * @param time2
     * @return
     */
    String queryUpOrDownNum(@Param("time2") String time2,@Param("acrossdatabase") String acrossdatabase);

    /**
     * 新增上架流程表
     * @param goodsBrandOnTheAuditVo
     */
    void insertintoUporDown(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo);

    /**
     * 更新上下架流程表
     * @param acrossdatabase
     * @param processid
     */
    void UpdateUporDownProcess(@Param("acrossdatabase") String acrossdatabase,@Param("processid") String processid,@Param("time")String time);

    /**
     * 终止操作上下架流程表，不同意上架
     * @param acrossdatabase
     * @param processid
     * @param time
     */
    void UpdateEndUporDownProcess(@Param("acrossdatabase") String acrossdatabase,@Param("processid") String processid,@Param("time")String time);

    /**
     * 添加图片
     * @param
     */
    void insertintoimgs(GoodsPicturesVo goodsPicturesVo);


    /**
     * 查询图片id
     * @param path
     * @return
     */
    Integer queryimgid(String path);


    /**
     * 查询商品库查看
     * @param id
     * @return
     */
    GoodsBrandListDto GoodsQueryOne(@Param(value = "id") Integer id, @Param(value = "url") String url);

    /**
     * 查询当前商品对应的图片id
     * @param goodsBrandAddVo
     * @return
     */
    String queryurlid(GoodsBrandAddVo goodsBrandAddVo);

    /**
     * 删掉图片
     * @param pictureid
     */
    void deleteurlid(String pictureid);


    /**
     * 查询出图片
     * @param urlid
     */
    GoodsImgsDto queryGoodsImgs(@Param(value = "urlid") String urlid,@Param(value = "url") String url);
}
