package com.ekingwin.bas.cloud.protal.service.Impl;

import com.alibaba.druid.util.StringUtils;
import com.ekingwin.bas.cloud.infra.utils.file.FileUtils;
import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.protal.dao.CommodityManagementMapper;
import com.ekingwin.bas.cloud.protal.dto.*;
import com.ekingwin.bas.cloud.protal.service.ICommodityManagementService;
import com.ekingwin.bas.cloud.protal.vo.*;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;


import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Primary
public class CommodityManagementServiceImpl implements ICommodityManagementService {

    @Value("${dataSourceName}")
    private String acrossdatabase;
    @Value("${img.url}")
    private String url;
    @Value("${onTheAuditUrl}")
    private String onTheAuditUrl;
    @Value("${goods.targetDir}")
    private String goods_targetDir;
    @Value("${goods.imgurl}")
    private String goods_imgurl;

    @Autowired
    private CommodityManagementMapper commodityManagementMapper;

    /**
     * 销售量排行榜
     *
     * @param salesListVo
     * @return
     */
    @Override
    public PageInfo SalesList(SalesListVo salesListVo) {
        PageHelper.startPage(salesListVo.getPageNum(), salesListVo.getPageSize());
        salesListVo.setUrl(url);
        salesListVo.setAcrossdatabase(acrossdatabase);
        Calendar cal = Calendar.getInstance();
        String year = cal.get(Calendar.YEAR) + "";
        int month = cal.get(Calendar.MONTH) + 1;
        if (month >= 1 && month <= 9) {
            String month1 = "0" + month;
            String str = (year + '-' + month1);
            salesListVo.setStr(str);
        } else {
            String month1 = "" + month;
            String str = (year + '-' + month1);
            salesListVo.setStr(str);
        }

        List<SalesListDto> salesListDto = commodityManagementMapper.SalesList(salesListVo);
        PageInfo pageInfo = new PageInfo<>(salesListDto);
        return pageInfo;

    }

    /**
     * 销售量排行榜首页显示
     *
     * @param salesListDto
     * @return
     */
    @Override
    public Result TheHomepage(List<SalesListDto> salesListDto) {
        for (int i = 0; i < salesListDto.size(); i++) {
            salesListDto.get(i).setName(acrossdatabase);
            if (salesListDto.get(i).getGoodsid() != null
                    && !salesListDto.get(i).getGoodsid().toString().equals("")) {
                commodityManagementMapper.AddTheHomepage(salesListDto.get(i));
                return Result.ok("添加首页成功");
            } else {
                return Result.error("参数信息为空");
            }
        }
        return Result.error("添加失败");
    }

    /**
     * 销售量排行榜商品分类
     *
     * @param goodsClassifyVo
     * @return
     */
    @Override
    public Result GoodsClassify(GoodsClassifyVo goodsClassifyVo) {
        goodsClassifyVo.setName(acrossdatabase);
        List<GoodsClassifyDto> goodsClassifyDtos = commodityManagementMapper.GoodsClassify(goodsClassifyVo);
        return Result.ok(goodsClassifyDtos);
    }

    /**
     * 开票信息和收货地址列表接口
     *
     * @param invoiceShipAddressListVo
     * @return
     */
    @Override
    public PageInfo InvoiceShipAddressList(InvoiceShipAddressListVo invoiceShipAddressListVo) {
        PageHelper.startPage(invoiceShipAddressListVo.getPageNum(), invoiceShipAddressListVo.getPageSize());
        invoiceShipAddressListVo.setAcrossdatabase(acrossdatabase);
        List<InvoiceShipAddressListDto> invoiceShipAddressListDtos = commodityManagementMapper.InvoiceShipAddressList(invoiceShipAddressListVo);
        for (int i = 0; i < invoiceShipAddressListDtos.size(); i++) {
            invoiceShipAddressListVo.setCompanycode(invoiceShipAddressListDtos.get(i).getCompanycode());
            List<InvoiceShipAddressDto> address = commodityManagementMapper.InvoiceShipAddress(invoiceShipAddressListVo);
            invoiceShipAddressListDtos.get(i).setAddress(address);
        }

        PageInfo PageInfo = new PageInfo<>(invoiceShipAddressListDtos);
        return PageInfo;
    }

    /**
     * 开票信息和收货地址列表接口新增中的子接口查询公司名
     *
     * @param invoiceShipAddressListVo
     * @return
     */
    @Override
    public PageInfo InvoiceShipAddressAddCompany(InvoiceShipAddressListVo invoiceShipAddressListVo) {
        PageHelper.startPage(invoiceShipAddressListVo.getPageNum(), invoiceShipAddressListVo.getPageSize());
        invoiceShipAddressListVo.setAcrossdatabase(acrossdatabase);
        List<InvoiceShipAddressAddCompanyDto> companyDtoList = commodityManagementMapper.InvoiceShipAddressAddCompany(invoiceShipAddressListVo);
        PageInfo PageInfo = new PageInfo<>(companyDtoList);
        return PageInfo;
    }

    /**
     * 开票信息和收货地址列表接口新增
     *
     * @param shipAddressAddVo
     * @param
     */
    @Override
    public Result invoiceShipAddressAdd(InvoiceShipAddressAddVo shipAddressAddVo) {
        shipAddressAddVo.setAcrossdatabase(acrossdatabase);
        List<InvoiceShipAddressAddsVo> vo = shipAddressAddVo.getInvoiceShipAddressAddsVo();
        int count = commodityManagementMapper.queryCompanycode(shipAddressAddVo);
        if (count == 0) {
            String time = null;
            Date date = new Date();
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = d.format(date);
            shipAddressAddVo.setUpdatedate(time);
            commodityManagementMapper.insertintoInvoice(shipAddressAddVo);
            for (int i = 0; i < vo.size(); i++) {
                vo.get(i).setDatabase(acrossdatabase);
                commodityManagementMapper.insertintoAddress(vo.get(i));
            }
            return Result.ok("开票信息和收货地址添加成功");
        } else {
            return Result.error("已经存在该公司的收货地址和开票信息");

        }
    }

    /**
     * 开票信息和收货地址列表接口编辑
     *
     * @param shipAddressAddVo
     * @return
     */
    @Override
    public Result invoiceShipAddressUpdate(InvoiceShipAddressAddVo shipAddressAddVo) {
        shipAddressAddVo.setAcrossdatabase(acrossdatabase);
        List<InvoiceShipAddressAddsVo> vo = shipAddressAddVo.getInvoiceShipAddressAddsVo();
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        shipAddressAddVo.setUpdatedate(time);
        //更新开票信息
        commodityManagementMapper.invoiceShipAddressUpdate(shipAddressAddVo);
        for (int i = 0; i < vo.size(); i++) {
            vo.get(i).setDatabase(acrossdatabase);
            //删除收货地址
            commodityManagementMapper.invoiceShipAddressdelete(vo.get(i));
            //新增收货地址
            commodityManagementMapper.insertintoAddress(vo.get(i));
            return Result.ok("开票信息和收货地址更新成功");
        }
        return Result.error("开票信息和收货地址更新失败");
    }

    /**
     * 开票信息和收货地址列表接口删除
     *
     * @param shipAddressAddVo
     * @return
     */
    @Override
    public Result invoiceShipAddressDelete(InvoiceShipAddressAddVo shipAddressAddVo) {
        shipAddressAddVo.setAcrossdatabase(acrossdatabase);
        List<InvoiceShipAddressAddsVo> vo = shipAddressAddVo.getInvoiceShipAddressAddsVo();

        //删除开票信息
        commodityManagementMapper.invoiceShipAddressDelete(shipAddressAddVo);

        for (int i = 0; i < vo.size(); i++) {
            vo.get(i).setDatabase(acrossdatabase);
            //删除收货地址
            commodityManagementMapper.invoiceShipAddressdelete(vo.get(i));
            return Result.ok("删除成功");
        }
        return Result.error("删除失败");
    }

    /**
     * 广告位列表查询接口
     *
     * @param advertiseListVo
     * @return
     */
    @Override
    public PageInfo AdvertiseList(AdvertiseListVo advertiseListVo) {
        PageHelper.startPage(advertiseListVo.getPageNum(), advertiseListVo.getPageSize());
        advertiseListVo.setAcrossdatabase(acrossdatabase);
        List<AdvertiseListDto> advertiseListDtos = commodityManagementMapper.AdvertiseList(advertiseListVo);
        PageInfo pageInfo = new PageInfo<>(advertiseListDtos);
        return pageInfo;
    }

    /**
     * 广告位列表新增子接口广告位编号查询
     *
     * @return
     */
    @Override
    public Result AdvertiseAddCode() {
        List<AdvertiseListDto> advertiseListDtos = commodityManagementMapper.AdvertiseAddCode();
        return Result.ok(advertiseListDtos);
    }

    /**
     * 广告位列表新增
     *
     * @return
     */
    @Override
    public Result AdvertiseAdd(AdvertiseAddVo advertiseAddVo) {
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        advertiseAddVo.setUpdatedate(time);
        //获取当前登录人信息
        String remoteUser = null;
        try {
            remoteUser = WebUtils.getRequest().getRemoteUser();
            if (StringUtils.isEmpty(remoteUser)) {
                remoteUser = WebUtils.getRequest().getParameter("username");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (remoteUser == null || remoteUser.equals("")) {
            remoteUser = "test02";
            advertiseAddVo.setSubmitpeople(remoteUser);
        } else {
            advertiseAddVo.setSubmitpeople(remoteUser);
        }

        try {
            commodityManagementMapper.AdvertiseAdd(advertiseAddVo);
            return Result.ok("广告位列表新增成功");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("广告位列表新增失败");
        }
    }

    /**
     * 广告位列表编辑
     *
     * @param advertiseAddVo
     * @return
     */
    @Override
    public Result AdvertiseUpdate(AdvertiseAddVo advertiseAddVo) {
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        advertiseAddVo.setUpdatedate(time);
        //获取当前登录人信息
        String remoteUser = null;
        try {
            remoteUser = WebUtils.getRequest().getRemoteUser();
            if (StringUtils.isEmpty(remoteUser)) {
                remoteUser = WebUtils.getRequest().getParameter("username");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (remoteUser == null || remoteUser.equals("")) {
            remoteUser = "test02";
            advertiseAddVo.setSubmitpeople(remoteUser);
        } else {
            advertiseAddVo.setSubmitpeople(remoteUser);
        }

        try {
            commodityManagementMapper.AdvertiseUpdate(advertiseAddVo);
            return Result.ok("广告位列表更新成功");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("广告位列表更新失败");
        }
    }

    /**
     * 广告位列表删除
     *
     * @param advertiseAddVo
     * @return
     */
    @Override
    public Result AdvertiseDelete(AdvertiseAddVo advertiseAddVo) {
        try {
            commodityManagementMapper.AdvertiseDelete(advertiseAddVo);
            return Result.ok("删除成功");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("删除失败");
        }
    }

    /**
     * 商品库商品分类
     *
     * @param goodsClassifyVo
     * @return
     */
    @Override
    public Result GoodsClassifys(GoodsClassifyVo goodsClassifyVo) {
        goodsClassifyVo.setName(acrossdatabase);
        //查询一级商品库商品分类信息
        List<GoodsFirstClassifyDto> goodsFirstClassifyDtos = commodityManagementMapper.queryFirstGoodsClassify(goodsClassifyVo);
        for (int i = 0; i < goodsFirstClassifyDtos.size(); i++) {
            goodsClassifyVo.setFirstid(goodsFirstClassifyDtos.get(i).getId());
            //查询二级商品库商品分类信息
            List<GoodsSecondClassifyDto> goodsSecondClassifyDtos = commodityManagementMapper.querySecondGoodsClassify(goodsClassifyVo);
            for (int j = 0; j < goodsSecondClassifyDtos.size(); j++) {
                goodsClassifyVo.setSecondid(goodsSecondClassifyDtos.get(j).getId());
                //查询三级商品库商品分类信息
                List<GoodsThirdClassifyDto> goodsThirdClassifyDtos = commodityManagementMapper.queryThirdGoodsClassify(goodsClassifyVo);
                for (int k = 0; k < goodsThirdClassifyDtos.size(); k++) {
                    goodsClassifyVo.setThirdid(goodsThirdClassifyDtos.get(k).getId());
                    //查询四级商品库商品分类信息
                    List<GoodsFourthClassifyDto> goodsFourthClassifyDtos = commodityManagementMapper.queryFourthGoodsClassify(goodsClassifyVo);
                    goodsFirstClassifyDtos.get(i).setChildren(goodsSecondClassifyDtos);
                    goodsSecondClassifyDtos.get(j).setChildren(goodsThirdClassifyDtos);
                    goodsThirdClassifyDtos.get(k).setChildren(goodsFourthClassifyDtos);

                }
            }
        }
        return Result.ok(goodsFirstClassifyDtos);
    }

    /**
     * 通威商品库查询
     *
     * @param goodsBrandListVo
     * @return
     */
    @Override
    public PageInfo GoodsBrandList(GoodsBrandListVo goodsBrandListVo) {
        PageHelper.startPage(goodsBrandListVo.getPageNum(), goodsBrandListVo.getPageSize());
        goodsBrandListVo.setUrl(url);
        List<GoodsBrandListDto> goodsBrandListDtos = commodityManagementMapper.GoodsBrandList(goodsBrandListVo);
        PageInfo pageInfo = new PageInfo<>(goodsBrandListDtos);
        return pageInfo;
    }

    /**
     * 商品库新增中基本信息子接口的商品名称查询
     *
     * @param materielImportVo
     * @return
     */
    @Override
    public PageInfo MaterielImport(MaterielImportVo materielImportVo) {
        PageHelper.startPage(materielImportVo.getPageNum(), materielImportVo.getPageSize());
        List<MaterielImportDto> materielImportDtos = commodityManagementMapper.MaterielImport(materielImportVo);
        for (int i = 0; i < materielImportDtos.size(); i++) {
            materielImportDtos.get(i).setSub(materielImportDtos.get(i).getId() + materielImportDtos.get(i).getName()
                    + materielImportDtos.get(i).getMateriecode() + materielImportDtos.get(i).getUnit() + materielImportDtos.get(i).getBrand()
                    + materielImportDtos.get(i).getBrandname() + materielImportDtos.get(i).getFTNPFirstCategoryName()
                    + materielImportDtos.get(i).getFTNPThreeCategoryName());
        }
        PageInfo pageInfo = new PageInfo<>(materielImportDtos);
        return pageInfo;
    }

    /**
     * 商品库新增中基本信息子接口的供应商名称查询
     *
     * @param supplierMaterielVo
     * @return
     */
    @Override
    public PageInfo querySupplierMateriel(SupplierMaterielVo supplierMaterielVo) {
        PageHelper.startPage(supplierMaterielVo.getPageNum(), supplierMaterielVo.getPageSize());
        if (supplierMaterielVo.getBrandname() != null && !supplierMaterielVo.getBrandname().equals("")) {
            List<SupplierMaterielDto> supplierMaterielDtos = commodityManagementMapper.querySupplierMateriel(supplierMaterielVo);
            for (int i = 0; i < supplierMaterielDtos.size(); i++) {
                supplierMaterielDtos.get(i).setSubject(supplierMaterielDtos.get(i).getId() + supplierMaterielDtos.get(i).getFullname()
                        + supplierMaterielDtos.get(i).getNum() + supplierMaterielDtos.get(i).getEnname() + supplierMaterielDtos.get(i).getAddress()
                        + supplierMaterielDtos.get(i).getUnitecode());
            }
            PageInfo pageInfo = new PageInfo<>(supplierMaterielDtos);
            return pageInfo;

        } else {
            //supplierMaterielVo.setBrandname("错误提示：商品名称不能为空，请输入完商品名称后再来查询");
            ArrayList list = new ArrayList();
            list.add(Result.error("商品名称不能为空，请输入完商品名称后再来查询"));
            PageInfo pageInfo = new PageInfo<>(list);
            return pageInfo;
        }
    }

    /**
     * 商品库新增销售区域查询
     *
     * @param goodsClassifyVo
     * @return
     */
    @Override
    public Result querySalesareaName(GoodsClassifyVo goodsClassifyVo) {
        goodsClassifyVo.setName(acrossdatabase);
        //销售区域一级查询
        List<SalesareaFirstNameDto> salesareaFirstNameDto = commodityManagementMapper.queryFirstSalesareaName(goodsClassifyVo);
        for (int H = 0; H < salesareaFirstNameDto.size(); H++) {
            goodsClassifyVo.setFirstid(salesareaFirstNameDto.get(H).getId());
            //销售区域二级查询
            List<SalesareaSecondNameDto> salesareaSecondNameDtos = commodityManagementMapper.querySecondSalesareaName(goodsClassifyVo);
            for (int i = 0; i < salesareaSecondNameDtos.size(); i++) {
                goodsClassifyVo.setSecondid(salesareaSecondNameDtos.get(i).getId());
                //销售区域三级查询
                List<SalesareaThirdNameDto> salesareaThirdNameDtos = commodityManagementMapper.queryThirdSalesareaName(goodsClassifyVo);
                for (int j = 0; j < salesareaThirdNameDtos.size(); j++) {
                    goodsClassifyVo.setThirdid(salesareaThirdNameDtos.get(j).getId());
                    //销售区域四级查询
                    List<SalesareaFourthNameDto> salesareaFourthNameDtos = commodityManagementMapper.queryFourthSalesareaName(goodsClassifyVo);
                    for (int k = 0; k < salesareaFourthNameDtos.size(); k++) {
                        goodsClassifyVo.setFourthid(salesareaFourthNameDtos.get(k).getId());
                        //销售区域五级查询
                        List<SalesareaFiveNameDto> salesareaFiveNameDtos = commodityManagementMapper.queryFiveSalesareaName(goodsClassifyVo);
                        salesareaFirstNameDto.get(H).setSalesareaNameDto(salesareaSecondNameDtos);
                        salesareaSecondNameDtos.get(i).setSalesareaNameDto(salesareaThirdNameDtos);
                        salesareaThirdNameDtos.get(j).setSalesareaNameDto(salesareaFourthNameDtos);
                        salesareaFourthNameDtos.get(k).setSalesareaNameDto(salesareaFiveNameDtos);
                    }
                }
            }
        }
        return Result.ok(salesareaFirstNameDto);
    }


    //sql遍历循环案例
//    @Override
//    public Result querySalesareaName(GoodsClassifyVo goodsClassifyVo) {
//        goodsClassifyVo.setName(acrossdatabase);
//        List<Integer> FirstId = new ArrayList<>();
//        List<Integer> SecondId = new ArrayList<>();
//        List<Integer> ThirdId = new ArrayList<>();
//        List<Integer> FourthId = new ArrayList<>();
//        List<SalesareaFirstNameDto> salesareaFirstNameDto = commodityManagementMapper.queryFirstSalesareaName(goodsClassifyVo);
//        for (int H = 0; H < salesareaFirstNameDto.size(); H++) {
//            FirstId.add(salesareaFirstNameDto.get(H).getId());
//        }
//        goodsClassifyVo.setList(FirstId);
//
//        List<SalesareaSecondNameDto> salesareaSecondNameDtos = commodityManagementMapper.querySecondSalesareaName(goodsClassifyVo);
//        for (int i = 0; i < salesareaSecondNameDtos.size(); i++) {
//            SecondId.add(salesareaSecondNameDtos.get(i).getId());
//        }
//        goodsClassifyVo.setList(SecondId);
//        List<SalesareaThirdNameDto> salesareaThirdNameDtos = commodityManagementMapper.queryThirdSalesareaName(goodsClassifyVo);
//        for (int j = 0; j < salesareaThirdNameDtos.size(); j++) {
//            ThirdId.add(salesareaThirdNameDtos.get(j).getId());
//        }
//        goodsClassifyVo.setList(ThirdId);
//        List<SalesareaFourthNameDto> salesareaFourthNameDtos = commodityManagementMapper.queryFourthSalesareaName(goodsClassifyVo);
//        for (int k = 0; k < salesareaFourthNameDtos.size(); k++) {
//            FourthId.add(salesareaFourthNameDtos.get(k).getId());
//        }
//        goodsClassifyVo.setList(FourthId);
//        List<SalesareaFiveNameDto> salesareaFiveNameDtos = commodityManagementMapper.queryFiveSalesareaName(goodsClassifyVo);
//        for (int a = 0; a < salesareaFirstNameDto.size(); a++) {
//            salesareaFirstNameDto.get(a).setSalesareaNameDto(salesareaSecondNameDtos);
//        }
//        for (int b = 0; b < salesareaSecondNameDtos.size(); b++) {
//            salesareaSecondNameDtos.get(b).setSalesareaNameDto(salesareaThirdNameDtos);
//
//        }
//        for (int c = 0; c < salesareaThirdNameDtos.size(); c++) {
//            salesareaThirdNameDtos.get(c).setSalesareaNameDto(salesareaFourthNameDtos);
//
//        }
//
//        for (int d = 0; d < salesareaFourthNameDtos.size(); d++) {
//            salesareaFourthNameDtos.get(d).setSalesareaNameDto(salesareaFiveNameDtos);
//        }
//
//        return Result.ok(salesareaFirstNameDto);
//    }

    /**
     * 商品库更改状态为下架
     *
     * @param goodsBrandSoldOutVo
     * @return
     */
    @Override
    public Result GoodsBrandSoldOut(GoodsBrandSoldOutVo goodsBrandSoldOutVo) {
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        List<GoodsBrandSoldOutIdVo> goodsBrandSoldOutIdVos = goodsBrandSoldOutVo.getGoodsBrandSoldOutIdVos();
        for (int i = 0; i < goodsBrandSoldOutIdVos.size(); i++) {
            if (goodsBrandSoldOutIdVos.get(i).getId() != null && !goodsBrandSoldOutIdVos.get(i).getId().equals("")) {
                goodsBrandSoldOutIdVos.get(i).setDescription(goodsBrandSoldOutVo.getReason());
                if (goodsBrandSoldOutIdVos.get(i).getDescription() != null && !goodsBrandSoldOutIdVos.get(i).getDescription().equals("")) {
                    //获取当前时间
                    goodsBrandSoldOutIdVos.get(i).setSuccessdate(time);
                    //更改状态
                    commodityManagementMapper.GoodsBrandSoldOut(goodsBrandSoldOutIdVos.get(i));
                    return Result.ok("下架成功！");
                } else {
                    return Result.error("请输入下架原因！");
                }
            } else {
                return Result.error("请选择商品后再试");
            }
        }
        return Result.error("下架失败");
    }

    /**
     * 商品库更改状态为上架发起
     *
     * @param goodsBrandOnTheAuditVo
     * @return
     */
    @Override
    public Result GoodsBrandOnTheAudit(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo) {
        goodsBrandOnTheAuditVo.setDatabase(acrossdatabase);
        //查询此商品状态是否为合格，或者为试用状态
        String code = commodityManagementMapper.GoodsBrandOnTheAudit(goodsBrandOnTheAuditVo);
        if (code.equals("合格") || code.equals("试用")) {
            //如果是C类商品，不走审批，直接上架
            if (goodsBrandOnTheAuditVo.getMaterialclassify().equals("C")) {
                commodityManagementMapper.UpdategoodsUpOrDownProcessRest_PS(goodsBrandOnTheAuditVo.getGoodsnum());
                return Result.ok("上架成功");
            }
            //查询是否是在审核的商品
            List<SupplierPageMessageDto> supplierPageMessageDtos = commodityManagementMapper.queryGoodsUpordown(goodsBrandOnTheAuditVo);
            for (int i = 0; i < supplierPageMessageDtos.size(); i++) {
                if (supplierPageMessageDtos.get(i).getMessage().equals("1")) {
                    return Result.ok("该商品正在审核中，请耐心等待");
                }
            }

            //查询商品库信息
            GoodsBrandOnTheAuditDto goodsBrandOnTheAuditDto = commodityManagementMapper.queryGoodsMessage(goodsBrandOnTheAuditVo);
            goodsBrandOnTheAuditDto.setApplyId(goodsBrandOnTheAuditVo.getUserid());
            goodsBrandOnTheAuditDto.setApplyName(goodsBrandOnTheAuditVo.getCnname());
            goodsBrandOnTheAuditDto.setBaseOrgId(goodsBrandOnTheAuditVo.getPositionothersystemid());
            goodsBrandOnTheAuditDto.setStationId(goodsBrandOnTheAuditVo.getPositionothersystemid());
            goodsBrandOnTheAuditDto.setTitle("商品上架信息");

            Map<String, Object> result = new HashMap<String, Object>();
            UUID uuid = UUID.randomUUID();
            if (goodsBrandOnTheAuditDto.getBaseOrgName() == null) {
                goodsBrandOnTheAuditDto.setBaseOrgName("");
            }
            if (goodsBrandOnTheAuditDto.getBrand() == null) {
                goodsBrandOnTheAuditDto.setBrand("");
            }
            if (goodsBrandOnTheAuditDto.getBrandname() == null) {
                goodsBrandOnTheAuditDto.setBrandname("");
            }
            if (goodsBrandOnTheAuditDto.getBussinessId() == null) {
                goodsBrandOnTheAuditDto.setBussinessId("");
            }
            if (goodsBrandOnTheAuditDto.getCreationDate() == null) {
                goodsBrandOnTheAuditDto.setCreationDate("");
            }
            if (goodsBrandOnTheAuditDto.getDeliverydate() == null) {
                goodsBrandOnTheAuditDto.setDeliverydate("");
            }
            if (goodsBrandOnTheAuditDto.getDeliveryplace() == null) {
                goodsBrandOnTheAuditDto.setDeliveryplace("");
            }
            if (goodsBrandOnTheAuditDto.getFreightcharges() == null) {
                goodsBrandOnTheAuditDto.setFreightcharges("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPFirstCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPFirstCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPFirstCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPFirstCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPSecondCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPSecondCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPThreeCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPThreeCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPSecondCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPSecondCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPThreeCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPThreeCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getGoodsid() == null) {
                goodsBrandOnTheAuditDto.setGoodsid("");
            }
            if (goodsBrandOnTheAuditDto.getGoodsname() == null) {
                goodsBrandOnTheAuditDto.setGoodsname("");
            }
            if (goodsBrandOnTheAuditDto.getInvoicetype() == null) {
                goodsBrandOnTheAuditDto.setInvoicetype("");
            }
            if (goodsBrandOnTheAuditDto.getIsAsk() == null) {
                goodsBrandOnTheAuditDto.setIsAsk("");
            }
            if (goodsBrandOnTheAuditDto.getLink() == null) {
                goodsBrandOnTheAuditDto.setLink("");
            }
            if (goodsBrandOnTheAuditDto.getMaterialclassify() == null) {
                goodsBrandOnTheAuditDto.setMaterialclassify("");
            }
            if (goodsBrandOnTheAuditDto.getMaterielsid() == null) {
                goodsBrandOnTheAuditDto.setMaterielsid("");
            }
            if (goodsBrandOnTheAuditDto.getPrice() == null) {
                goodsBrandOnTheAuditDto.setPrice("");
            }
            if (goodsBrandOnTheAuditDto.getPrice2() == null) {
                goodsBrandOnTheAuditDto.setPrice2("");
            }
            if (goodsBrandOnTheAuditDto.getPricetype() == null) {
                goodsBrandOnTheAuditDto.setPricetype("");
            }
            if (goodsBrandOnTheAuditDto.getProcessCode() == null) {
                goodsBrandOnTheAuditDto.setProcessCode("");
            }
            if (goodsBrandOnTheAuditDto.getProcessId() == null) {
                goodsBrandOnTheAuditDto.setProcessId("");
            }
            if (goodsBrandOnTheAuditDto.getReason() == null) {
                goodsBrandOnTheAuditDto.setReason("");
            }
            if (goodsBrandOnTheAuditDto.getSalesarea() == null) {
                goodsBrandOnTheAuditDto.setSalesarea("");
            }
            if (goodsBrandOnTheAuditDto.getSalesareaname() == null) {
                goodsBrandOnTheAuditDto.setSalesareaname("");
            }
            if (goodsBrandOnTheAuditDto.getStationName() == null) {
                goodsBrandOnTheAuditDto.setStationName("");
            }
            if (goodsBrandOnTheAuditDto.getSuccessdate() == null) {
                goodsBrandOnTheAuditDto.setSuccessdate("");
            }
            if (goodsBrandOnTheAuditDto.getSupplier() == null) {
                goodsBrandOnTheAuditDto.setSupplier("");
            }
            if (goodsBrandOnTheAuditDto.getSupplierid() == null) {
                goodsBrandOnTheAuditDto.setSupplierid("");
            }
            if (goodsBrandOnTheAuditDto.getSystemCode() == null) {
                goodsBrandOnTheAuditDto.setSystemCode("");
            }
            if (goodsBrandOnTheAuditDto.getTaxrate() == null) {
                goodsBrandOnTheAuditDto.setTaxrate("");
            }
            if (goodsBrandOnTheAuditDto.getUnit() == null) {
                goodsBrandOnTheAuditDto.setUnit("");
            }
            JSONObject json = new JSONObject();
            json.element("applyId", goodsBrandOnTheAuditDto.getApplyId());
            json.element("applyName", goodsBrandOnTheAuditDto.getApplyName());
            json.element("baseOrgId", goodsBrandOnTheAuditDto.getBaseOrgId());
            json.element("baseOrgName", goodsBrandOnTheAuditDto.getBaseOrgName());
            json.element("bussinessId", goodsBrandOnTheAuditDto.getBussinessId());
            json.element("creationDate", goodsBrandOnTheAuditDto.getCreationDate());
            json.element("brand", goodsBrandOnTheAuditDto.getBrand());
            json.element("brandname", goodsBrandOnTheAuditDto.getBrandname());
            json.element("deliverydate", goodsBrandOnTheAuditDto.getDeliverydate());
            json.element("deliveryplace", goodsBrandOnTheAuditDto.getDeliveryplace());
            json.element("freightcharges", goodsBrandOnTheAuditDto.getFreightcharges());
            json.element("FTNPFirstCategoryCode", goodsBrandOnTheAuditDto.getFTNPFirstCategoryCode());
            json.element("FTNPFirstCategoryName", goodsBrandOnTheAuditDto.getFTNPFirstCategoryName());
            json.element("FTNPSecondCategoryCode", goodsBrandOnTheAuditDto.getFTNPSecondCategoryCode());
            json.element("FTNPSecondCategoryName", goodsBrandOnTheAuditDto.getFTNPSecondCategoryName());
            json.element("FTNPThreeCategoryCode", goodsBrandOnTheAuditDto.getFTNPThreeCategoryCode());
            json.element("FTNPThreeCategoryName", goodsBrandOnTheAuditDto.getFTNPThreeCategoryName());
            json.element("goodsid", goodsBrandOnTheAuditDto.getGoodsid());
            json.element("goodsname", goodsBrandOnTheAuditDto.getGoodsname());
            json.element("invoicetype", goodsBrandOnTheAuditDto.getInvoicetype());
            json.element("isAsk", goodsBrandOnTheAuditDto.getIsAsk());
            json.element("link", goodsBrandOnTheAuditDto.getLink());
            json.element("materialclassify", goodsBrandOnTheAuditDto.getMaterialclassify());
            json.element("materielsid", goodsBrandOnTheAuditDto.getMaterielsid());
            json.element("price", goodsBrandOnTheAuditDto.getPrice());
            json.element("price2", goodsBrandOnTheAuditDto.getPrice2());
            json.element("pricetype", goodsBrandOnTheAuditDto.getPricetype());
            json.element("processCode", goodsBrandOnTheAuditDto.getProcessCode());
            json.element("processId", goodsBrandOnTheAuditDto.getProcessId());
            json.element("reason", goodsBrandOnTheAuditDto.getReason());
            json.element("salesarea", goodsBrandOnTheAuditDto.getSalesarea());
            json.element("salesareaname", goodsBrandOnTheAuditDto.getSalesareaname());
            json.element("stationId", goodsBrandOnTheAuditDto.getStationId());
            json.element("stationName", goodsBrandOnTheAuditDto.getStationName());
            json.element("successdate", goodsBrandOnTheAuditDto.getSuccessdate());
            json.element("supplier", goodsBrandOnTheAuditDto.getSupplier());
            json.element("supplierid", goodsBrandOnTheAuditDto.getSupplierid());
            json.element("systemCode", goodsBrandOnTheAuditDto.getSystemCode());
            json.element("taxrate", goodsBrandOnTheAuditDto.getTaxrate());
            json.element("title", goodsBrandOnTheAuditDto.getTitle());
            json.element("unit", goodsBrandOnTheAuditDto.getUnit());
            try {
                System.out.println(json);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                //拼写接口报文
                RestTemplate restTemplate = new RestTemplate();
                //向接口传递数据
                //拼写好的报文提交
                HttpEntity<JSONObject> he = new HttpEntity<JSONObject>(json, headers);
                @SuppressWarnings("rawtypes")
                ResponseEntity<Map> resultjson = restTemplate.exchange(onTheAuditUrl, HttpMethod.POST, he, Map.class);
                Map<String, Object> restmap = resultjson.getBody();
//                JsonMapper jsonMapper = new JsonMapper();
                String retCode = restmap.get("retCode").toString();
                String processId = restmap.get("processId").toString();
                String reqno = restmap.get("reqno").toString();
                String retMsg = restmap.get("retMsg").toString();
                String fbcUrl = restmap.get("fbcUrl").toString();
                String bussinessType = restmap.get("bussinessType").toString();
                String bussinessId = restmap.get("bussinessId").toString();
//                Map<String,Object> jsonm = jsonMapper.fromJson(restmap.get("retCode").toString(), Map.class);
                if (retCode.equals("Y")) {
                    String time = null;
                    String time2 = null;
                    Date date = new Date();
                    SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat d2 = new SimpleDateFormat("yyyyMMdd");
                    time = d.format(date);
                    time2 = d2.format(date);

                    goodsBrandOnTheAuditVo.setInputdate(time);
                    goodsBrandOnTheAuditVo.setCode("1");
                    goodsBrandOnTheAuditVo.setBpmurl(fbcUrl);
                    goodsBrandOnTheAuditVo.setProcessid(processId);
                    goodsBrandOnTheAuditVo.setReqno(reqno);
                    goodsBrandOnTheAuditVo.setBussinessid(bussinessId);
                    goodsBrandOnTheAuditVo.setBussinesstype(bussinessType);

                    //逻辑查询上下架次数
                    String num = commodityManagementMapper.queryUpOrDownNum(time2, acrossdatabase);
                    if (num.equals("") || num == null) {
                        String upnum = time2 + "0001";
                        goodsBrandOnTheAuditVo.setUpnum(upnum);
                    } else {
                        BigInteger b = new BigInteger(num);
                        BigInteger c = new BigInteger("1");
                        //BigInteger的加法运算
                        String upnum = b.add(c) + "";
                        goodsBrandOnTheAuditVo.setUpnum(upnum);
                    }
                    goodsBrandOnTheAuditVo.setSubject(goodsBrandOnTheAuditVo.getSupplier() + goodsBrandOnTheAuditVo.getName());
                    goodsBrandOnTheAuditVo.setAction("up");
                    goodsBrandOnTheAuditVo.setBpmid("0");
                    goodsBrandOnTheAuditVo.setUrl("http://174.34.53.78:8001/BPMProject/bpm/process-space!viewForm.do?instid=0&processname=UAESShopApply&processnodename=&grantor=&taskid=83802&title=");
                    try {
                        //新增商品上下架表数据
                        commodityManagementMapper.insertGoodsUpOrDown(goodsBrandOnTheAuditVo);
                        //新增上架流程表
                        commodityManagementMapper.insertintoUporDown(goodsBrandOnTheAuditVo);
                    } catch (Exception e) {
                        e.printStackTrace();
                        return Result.error("新增上下架信息错误");
                    }
                } else {
                    return Result.error("调用失败");
                }


            } catch (Exception e) {
                System.out.println("请求报文：" + json);
                System.out.println("请求调用失败" + e);
                return Result.error("服务器异常");
            }
            return Result.ok("已发起审批，请耐心等待");
        } else {
            return Result.error("供应商不是合格或试用供应商，不能上架！");
        }
    }

    /**
     * 商品库更改状态为上架审批回传
     *
     * @param map
     * @return
     */
    @Override
    public Result goodsUpOrDownProcessRest_PS(Map<String, Object> map) {
        String state = (String) map.get("state");
        String processid = (String) map.get("processid");
        String goodsnum = (String) map.get("goodsid");
        String opinion = (String) map.get("opinion");

        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);

        if ("Y".equals(state)) {
            //更新商品上架
            commodityManagementMapper.UpdategoodsUpOrDownProcessRest_PS(goodsnum);
            //更新上下架表状态
            commodityManagementMapper.UpdategoodsUpOrDownProcessRest(processid, time, acrossdatabase);
            //更新上下架流程表
            commodityManagementMapper.UpdateUporDownProcess(acrossdatabase, processid, time);
            return Result.ok("上架成功");
        } else {
            //终止操作上架，不同意上架
            commodityManagementMapper.EndgoodsUpOrDownProcessRest(processid, time, acrossdatabase);
            //终止操作上下架流程表，不同意上架
            commodityManagementMapper.UpdateEndUporDownProcess(acrossdatabase, processid, time);
            return Result.error("上架失败，原因是：" + opinion);
        }

    }

    /**
     * 通威商品库新增
     *
     * @param goodsBrandAddVo
     * @return
     */
    @Override
    public Result GoodsBrandAdd(GoodsBrandAddVo goodsBrandAddVo) {
        String goodsnum = goodsBrandAddVo.getGoodsnum();
        //查询是否重复添加
        Integer count = commodityManagementMapper.querygoodsnum(goodsnum);
        if (count >= 1) {
            return Result.error("你已经添加此商品，不可重复添加");
        }
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        if (goodsBrandAddVo.getIsinquiry().equals("是")) {
            goodsBrandAddVo.setIsinquiry("Y");
            goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
        } else if (goodsBrandAddVo.getIsinquiry().equals("否")) {
            goodsBrandAddVo.setIsinquiry("N");
            goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
            goodsBrandAddVo.setMaxprice("");
        }

        if (goodsBrandAddVo.getFreightcharges().equals("是")) {
            goodsBrandAddVo.setFreightcharges("Y");
        } else if (goodsBrandAddVo.getFreightcharges().equals("否")) {
            goodsBrandAddVo.setFreightcharges("N");
        }
        for (int i = 0; i < goodsBrandAddVo.getGoodsPicturesVos().size(); i++) {

            //todo 物资图片
            try {
                //添加图片
                commodityManagementMapper.insertintoimgs(goodsBrandAddVo.getGoodsPicturesVos().get(i));
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("添加图片错误，请与管理员联系");
            }
            //查询图片id
            Integer id = commodityManagementMapper.queryimgid(goodsBrandAddVo.getGoodsPicturesVos().get(0).getPath());
            if (i == 0) {
                goodsBrandAddVo.setUrlid(id + "");
            } else if (i == 1) {
                int a1 = id + 1;
                goodsBrandAddVo.setUrlid(id + "," + a1);
            } else if (i == 2) {
                int a1 = id + 1;
                int a2 = id + 2;
                goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2);
            } else if (i == 3) {
                int a1 = id + 1;
                int a2 = id + 2;
                int a3 = id + 3;
                goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2 + "," + a3);
            } else if (i == 4) {
                int a1 = id + 1;
                int a2 = id + 2;
                int a3 = id + 3;
                int a4 = id + 4;
                goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2 + "," + a3 + "," + a4);
            } else if (i == 5) {
                return Result.error("错误提示：图片最多可上传5张");
            }
        }

        //状态 默认为6，待上架
        goodsBrandAddVo.setState("6");
        //销量默认为0
        goodsBrandAddVo.setSalesVolume(0);
        //获取当前时间
        goodsBrandAddVo.setInputdate(time);
        //获取当前登录人信息
        String remoteUser = null;
        try {
            remoteUser = WebUtils.getRequest().getRemoteUser();
            if (StringUtils.isEmpty(remoteUser)) {
                remoteUser = WebUtils.getRequest().getParameter("username");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (remoteUser == null || remoteUser.equals("")) {
            remoteUser = "jiaoy01";
            goodsBrandAddVo.setUserid(remoteUser);
        } else {
            goodsBrandAddVo.setUserid(remoteUser);
        }
        if (goodsBrandAddVo.getDetails() == null || goodsBrandAddVo.getDetails().equals("")) {
            goodsBrandAddVo.setDetails("/40b715e0-9399-11e8-8e1f-6bda1ebf5787.txt");
        }

        try {
            //新增
            commodityManagementMapper.GoodsBrandAdd(goodsBrandAddVo);
            return Result.ok("新增成功");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.ok("新增失败");
        }
    }

    /**
     * 通威商品库编辑
     *
     * @param goodsBrandAddVo
     * @return
     */
    @Override
    public Result GoodsBrandUpdate(GoodsBrandAddVo goodsBrandAddVo) {
        if (goodsBrandAddVo.getState().equals("1")) {
            return Result.error("上架商品不能编辑");
        } else {
            String time = null;
            Date date = new Date();
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = d.format(date);
            if (goodsBrandAddVo.getIsinquiry().equals("是")) {
                goodsBrandAddVo.setIsinquiry("Y");
                goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
            } else if (goodsBrandAddVo.getIsinquiry().equals("否")) {
                goodsBrandAddVo.setIsinquiry("N");
                goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
                goodsBrandAddVo.setMaxprice("");
            }

            if (goodsBrandAddVo.getFreightcharges().equals("是")) {
                goodsBrandAddVo.setFreightcharges("Y");
            } else if (goodsBrandAddVo.getFreightcharges().equals("否")) {
                goodsBrandAddVo.setFreightcharges("N");
            }

            //查询当前商品对应的图片id
            String pictureid = commodityManagementMapper.queryurlid(goodsBrandAddVo);
            //查看此字符串中是否有逗号
            boolean contains = pictureid.contains(",");
            if (contains == true) {
                //以逗号截取字符串
                String[] split = pictureid.split(",");
                for (int i = 0; i < split.length; i++) {
                    pictureid = split[i];
                    try {
                        //删掉图片
                        commodityManagementMapper.deleteurlid(pictureid);
                    } catch (Exception e) {
                        e.printStackTrace();
                        return Result.error("错误提示，请与管理员联系");
                    }
                }
            } else {
                //删掉图片
                try {
                    commodityManagementMapper.deleteurlid(pictureid);
                } catch (Exception e) {
                    e.printStackTrace();
                    return Result.error("错误提示，请与管理员联系");
                }
            }

            for (int i = 0; i < goodsBrandAddVo.getGoodsPicturesVos().size(); i++) {
                //todo 物资图片
                try {
                    //添加图片
                    commodityManagementMapper.insertintoimgs(goodsBrandAddVo.getGoodsPicturesVos().get(i));
                } catch (Exception e) {
                    e.printStackTrace();
                    return Result.error("添加图片错误，请与管理员联系");
                }
                //查询图片id
                Integer id = commodityManagementMapper.queryimgid(goodsBrandAddVo.getGoodsPicturesVos().get(0).getPath());
                if (i == 0) {
                    goodsBrandAddVo.setUrlid(id + "");
                } else if (i == 1) {
                    int a1 = id + 1;
                    goodsBrandAddVo.setUrlid(id + "," + a1);
                } else if (i == 2) {
                    int a1 = id + 1;
                    int a2 = id + 2;
                    goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2);
                } else if (i == 3) {
                    int a1 = id + 1;
                    int a2 = id + 2;
                    int a3 = id + 3;
                    goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2 + "," + a3);
                } else if (i == 4) {
                    int a1 = id + 1;
                    int a2 = id + 2;
                    int a3 = id + 3;
                    int a4 = id + 4;
                    goodsBrandAddVo.setUrlid(id + "," + a1 + "," + a2 + "," + a3 + "," + a4);
                } else if (i == 5) {
                    return Result.error("错误提示：图片最多可上传5张");
                }
            }


//            //状态 默认为6，待上架
//            goodsBrandAddVo.setState("6");
//            //销量默认为0
//            goodsBrandAddVo.setSalesVolume(0);
//            //获取当前时间
            goodsBrandAddVo.setInputdate(time);
            //获取当前登录人信息
            String remoteUser = null;
            try {
                remoteUser = WebUtils.getRequest().getRemoteUser();
                if (StringUtils.isEmpty(remoteUser)) {
                    remoteUser = WebUtils.getRequest().getParameter("username");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (remoteUser == null || remoteUser.equals("")) {
                remoteUser = "jiaoy01";
                goodsBrandAddVo.setUserid(remoteUser);
            } else {
                goodsBrandAddVo.setUserid(remoteUser);
            }
//            if (goodsBrandAddVo.getDetails() == null || goodsBrandAddVo.getDetails().equals("")) {
//                goodsBrandAddVo.setDetails("/40b715e0-9399-11e8-8e1f-6bda1ebf5787.txt");
//            }
            try {
                //编辑商品库
                commodityManagementMapper.GoodsBrandUpdate(goodsBrandAddVo);
                return Result.ok("更新成功");
            } catch (Exception e) {
                e.printStackTrace();
                return Result.ok("更新失败");
            }
        }

    }

    /**
     * 图片上传
     *
     * @param inputStream
     * @param name
     * @param fileMeta
     * @return
     */
    @Override
    public Result FileUploaded(InputStream inputStream, String name, Map<String, String[]> fileMeta) {

        //图片上传
        String ext = "";
        int extPos = name.lastIndexOf(".");
        if (extPos != -1) {
            ext = name.substring(extPos + 1, name.length());
        }
        String fileGuid = UUID.randomUUID().toString();

        File file = new File(goods_imgurl + fileGuid + "." + ext);

        try {
            FileUtils.inputStreamToFile(inputStream, file);
        } catch (Exception e) {
            return Result.error("上传文件失败" + e.getMessage());
        }
        // 保存文件本体
        FileUploadedDto df = new FileUploadedDto();
        try {
            //封装文件属性
            df.setExtension(ext);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误1");
        }
        try {
            df.setSize(file.length() + "");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误2");
        }
        try {
            df.setId(fileGuid);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误3");
        }
        try {
            df.setFilename(file.getName());
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误4");
        }
        try {
            df.setDDocname(name);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误5");
        }
        try {
            df.setAbspath(file.getAbsolutePath());
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误6");
        }
        try {
            //只要自己想要的那部分路径
            df.setPath("/file/file/img/" +file.getName());
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("错误7");
        }
        return Result.ok(df);

    }

    /**
     * 通威商品库查看
     *
     * @param id
     * @return
     */
    @Override
    public Result GoodsQueryOne(Integer id) {
        ArrayList list = new ArrayList<>();
        //查询商品库查看
        GoodsBrandListDto goodsBrandListDto = commodityManagementMapper.GoodsQueryOne(id, url);
        String urlid = goodsBrandListDto.getUrlid();
        //查看此字符串中是否有逗号
        boolean contains = urlid.contains(",");
        if (contains == true) {
            //以逗号截取字符串
            String[] split = urlid.split(",");
            for (int i = 0; i < split.length; i++) {
                urlid = split[i];
                //查询出图片
                GoodsImgsDto goodsImgsDtos = commodityManagementMapper.queryGoodsImgs(urlid, url);
                list.add(goodsImgsDtos);
            }
        } else {
            //查询出图片
            GoodsImgsDto goodsImgsDtos = commodityManagementMapper.queryGoodsImgs(urlid, url);
            list.add(goodsImgsDtos);
        }
        goodsBrandListDto.setGoodsImgsDtos(list);
        return Result.ok(goodsBrandListDto);
    }
}






