package com.ekingwin.bas.cloud.protal.web;

import com.ekingwin.bas.cloud.protal.service.IHomepageSearchService;
import com.ekingwin.bas.cloud.protal.vo.HomepageQueryVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/HomepageSearch")
@Api(tags = "首页搜索", description = "首页搜索", value = "首页搜索")
public class HomepageSearchController {

    @Autowired
    private IHomepageSearchService homepageSearchService;

    @PostMapping(value = "/HomepageQueryList")
    @ApiOperation(value = "首页搜索", notes = "首页搜索")
    public Result HomepageQueryList(@RequestBody HomepageQueryVo homepageQueryVo) throws Exception {
        PageInfo pageInfo = homepageSearchService.HomepageQueryList(homepageQueryVo);
        return Result.ok(pageInfo);
    }
}
