package com.ekingwin.bas.cloud.protal.web;

import com.ekingwin.bas.cloud.protal.dto.MaterielMessageDto;
import com.ekingwin.bas.cloud.protal.dto.SupplierListMessageDto;
import com.ekingwin.bas.cloud.protal.service.IMaterielMessageService;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/materiel")
@Api(tags = "物料数据信息", description = "物料数据信息", value = "物料数据信息")
public class MaterielMessageController {

    @Autowired
    private IMaterielMessageService materielMessageService;

    /**
     * 通过商品名称,编码，价格区间，状态查询物料全部信息，还可根据价格进行排序
     * @param message
     * @return
     * @throws Exception
     */
    @PostMapping(value = "/materielname/{message}")
    @ApiOperation(value = "查询物料全部信息", notes = "查询物料全部信息")
    public Result queryMaterielMessageByName(@PathVariable(value = "message") String message) throws Exception{
        List<MaterielMessageDto> messageDtos = materielMessageService.queryMaterielMessageByName(message);
        return  Result.ok(messageDtos);
    }

}
